%{
#include <stdio.h>
#include <string.h>
#include "InfoBase.h"
#include "ProtoParse.tab.h"
  //  int protolineno=1;
%}
/*%option reentrant */

/* no wrapping is needed; setting this means we don't have to link with libfl.a */
%option noyywrap

/* don't use the default-echo rules */
 //%option nodefault

/* I don't call unput */
%option nounput


/* use the "fast" algorithm with no table compression */
%option full

/* utilize character equivalence classes */
%option ecs

/* the scanner is never interactive */
%option never-interactive

%option prefix="proto"
%option outfile="lex.proto.c"   

   /*%option yylineno*/

/* caseless matching */
%option caseless



ws            ([ \t]*)
nl            (\n)
SPNUM          (61|63|68|99|114|253|254|255)
Eight_Bit     (([0-9])|([1-9][0-9])|(1[0-9][0-9])|(2[0-4][0-9])|(25[0-5]))
NUMBER_RANGE   ({Eight_Bit}\-{Eight_Bit})
WORD         ([^ \t\n]*)
%%

{ws}   ;
{nl}  {return nl;}
{Eight_Bit}/\. ;
{SPNUM} {protolval.dval=atoi(yytext);return SPNUM;}
{NUMBER_RANGE} {return NUMBER_RANGE;}
^{ws}{Eight_Bit}/[^\-0-9] {protolval.dval=atoi(yytext);return ENTNUM;}
{WORD} {protolval.strn = strdup(yytext); return WORD;}

%%

void protoerror(char *v)
{
  printf("%s:\n",v);
}
