%{
#include <stdio.h>
#include <string.h>
#include "InfoBase.h"
#include "PortParse.tab.h"
  //  int portlineno=1;
%}
/*%option reentrant */

/* no wrapping is needed; setting this means we don't have to link with libfl.a */
%option noyywrap

/* don't use the default-echo rules */
 //%option nodefault

/* I don't call unput */
%option nounput


/* use the "fast" algorithm with no table compression */
%option full

/* utilize character equivalence classes */
%option ecs

/* the scanner is never interactive */
%option never-interactive

%option prefix="port"
%option outfile="lex.port.c"   

   /*%option yylineno*/

/* caseless matching */
%option caseless


ws            ([ \t]*)
nl            (\n)
NUMBER       ([0-9]|[1-9][0-9]*)
END         (^\[\]$)
WORD         ([^ \t\n]*)
COMMENT      ([\#])
%%

{ws}   ;
{nl}  {return nl;}
^{COMMENT}.*$ {return COMMENT;}
{NUMBER}/(\/tcp) {portlval.dval=atoi(yytext);return TCP_NUMBER;}
{NUMBER}/(\/udp) {portlval.dval=atoi(yytext);return UDP_NUMBER; }
{END} {return END;}
{WORD} {portlval.strn = strdup(yytext); return WORD;}
%%

void porterror(char *v)
{
  printf("%s\n", v);
  //  printf("%d: %s:\n", portlineno, v);
}

