/* -*-	Mode:C++; c-basic-offset:2; tab-width:2; indent-tabs-mode:t -*- */
#include <map>
#include "Predicate.h"
#include <algorithm>
#include <iostream>
#include <iterator>
using namespace std;

std::map<std::string, bvec> Field::sbm;
std::string SIP_Field::name="sip";   //source IP address
std::string DIP_Field::name="dip";   //destination IP 
std::string SPT_Field::name="spt";   // source port
std::string DPT_Field::name="dpt";   // destination port
std::string Proto_Field::name="prt";  //protocol

//std::string ITF_Field::name="itf";   //interface, at most 32 interface allowed


int CIDR_Field::zoom_min=0;
int CIDR_Field::zoom_max=32;
int Port_Field::zoom_min=0;
int Port_Field::zoom_max=16;

int Proto_Field::zoom_min=0;
int Proto_Field::zoom_max=8;

/**
 * This function copied from C++ how-to
 */

void Tokenize(const string& str,
	      vector<string>& tokens,
	      const string& delimiters = " ")
{
    // Skip delimiters at beginning.
    string::size_type lastPos = str.find_first_not_of(delimiters, 0);
    // Find first "non-delimiter".
    string::size_type pos     = str.find_first_of(delimiters, lastPos);

    while (string::npos != pos || string::npos != lastPos)
    {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delimiters.  Note the "not_of"
        lastPos = str.find_first_not_of(delimiters, pos);
        // Find next "non-delimiter"
        pos = str.find_first_of(delimiters, lastPos);
    }
}


void Field::initMapping(int nodesize, int cachesize) 
{
  bdd_cpp_init(nodesize, cachesize);
  int domain[11] = {255,255,255,255, 255,255,255,255, 65535, 65535, 255};
  fdd_extdomain(domain,11);

  int vals[32];
  int i;
  for(i=0;i<32;i++){
    vals[i] = i;
  }
  sbm["sip"] = bvec_varvec(32, vals);

  for(i=0;i<32;i++){
    vals[i] = i+32;
  }
  sbm["dip"] = bvec_varvec(32, vals);

  for(i=0;i<16;i++){
    vals[i] = i+64;
  }
  sbm["spt"] = bvec_varvec(16, vals);


  for(i=0;i<16;i++){
    vals[i] = i+80;
  }
  sbm["dpt"]= bvec_varvec(16, vals);


  for (i=0;i<8;i++){
    vals[i] = i+64;
  }
  sbm["icmp_type"] = bvec_varvec(8, vals);


  for (i=0;i<8;i++){
    vals[i] = i+72;
  }
  sbm["icmp_code"] = bvec_varvec(8, vals);

  for(i=0;i<8;i++){
    vals[i] = i+96;
  }
  sbm["prt"] = bvec_varvec(8, vals);

}

bdd CIDR_Field:: toBDD(bvec V) {

  if (mask.s_addr == 0x00000000){
    return bddtrue;
  }
  
  if(mask.s_addr == 0xffffffff){
    bvec x = bvec_con(32, ntohl(addr.s_addr));
    bdd res = bvec_equ(V, x);
    return res;
  }

  int min = ntohl(this->net().s_addr);
  int max = ntohl(this->broadcast().s_addr);
  //cout << min << max<< endl;

  bvec x = bvec_con(32, min);
  bvec y = bvec_con(32, max);
  bdd a = bvec_gte(V, x);
  bdd b = bvec_lte(V, y);
  return bdd_and(a, b);
}


list<SIP_Field> SIP_Field::zoom_in(int nlevel)
{
  list<SIP_Field> res;
  list<CIDR>::iterator it;
  list<CIDR> c = subnets(nlevel);

  for (it = c.begin();it!= c.end();++it){
    SIP_Field s = SIP_Field(*it);
    res.push_back(s);
  }
  return res;
}

list<DIP_Field> DIP_Field::zoom_in(int nlevel)
{
  list<DIP_Field> res;
  list<CIDR>::iterator it;
  list<CIDR> c = subnets(nlevel);

  for (it = c.begin();it!= c.end();++it){
    SIP_Field s = DIP_Field(*it);
    res.push_back(s);
  }
  return res;
}

bdd Port_Field::toBDD(bvec V)
{
  //cout << left << "-"<< right << endl;
  assert (left <=right);

  bvec x = bvec_con(16, left);
  bvec y = bvec_con(16, right);
  bdd a = bvec_gte(V, x);
  bdd b = bvec_lte(V, y);
  return bdd_and(a, b);
}

void Predicate::set_proto(std::string  _proto)
{
  if(_proto=="*" or _proto =="any"){
    fields.erase("prt");
  }
  else{
    Proto_Field * a = new Proto_Field(_proto.c_str());
    fields.insert(make_pair("prt", (Field *) a));
  }
}

void Predicate::set_icmptype(string _ict)
{
  if(_ict=="*" or _ict =="any"){
    fields.erase("icmp_type");
  }
  else{
    set_icmptype(atoi(_ict.c_str()));
  }
}

void Predicate::set_icmptype(int _ict)
{
  ICMPType_Field *a = new ICMPType_Field(_ict);
  //cout << "set icmp "<< a->toString() << endl;
  fields.insert(make_pair("icmp_type", (Field *) a));
}

void Predicate::set_proto(int  _proto)
{
  Proto_Field * a = new Proto_Field(_proto);
  fields.insert(make_pair("prt", (Field *) a));
}


void Predicate::set_sip(std::string  _sip)
{
  //cout << "in set_sip " << _sip << endl;
  if(_sip=="*" or _sip =="any"){
    fields.erase("sip");
  } else {
    SIP_Field  * b = new SIP_Field(_sip.c_str());
    fields.insert(make_pair("sip", (Field *) b));
  }
}

void Predicate::set_sip(CIDR _sip)
{
  //cout << "in set_sip " << _sip.toString() << endl;
  if(_sip.isANY()){
    fields.erase("sip"); 
  }  else{
    SIP_Field  * b = new SIP_Field(_sip);
    fields.insert(make_pair("sip", (Field *) b));
  }
}

void Predicate::set_spt(std::string  _spt)
{
  if(_spt=="*" or _spt =="any"){
    fields.erase("spt");
  } else{
    SPT_Field * d = new SPT_Field(_spt.c_str());
    fields.insert(make_pair("spt", (Field *) d));    
  }
}


void Predicate::set_spt(int _spt)
{
  SPT_Field * d = new SPT_Field(_spt);
  fields.insert(make_pair("spt", (Field *) d));    
}

void Predicate::set_spt(const Port_Field &_spt)
{
  SPT_Field * d = new SPT_Field(_spt);
  fields.insert(make_pair("spt", (Field *)d));    
}



void Predicate::set_dip(std::string  _dip)
{
  if(_dip=="*" or _dip =="any"){
    fields.erase("dip") ;
  }
  else{
    DIP_Field * c = new DIP_Field(_dip.c_str());
    fields.insert(make_pair("dip", (Field *) c));
  }
}

void Predicate::set_dip(CIDR _dip)
{
  if(_dip.isANY()){
    fields.erase("dip");
  }
  else{ 
    DIP_Field  * b = new DIP_Field(_dip);
    fields.insert(make_pair("dip", (Field *) b));
  }
}


void Predicate::set_dpt(std::string  _dpt="any")
{
  if(_dpt=="*" or _dpt =="any"){
    fields.erase("dpt");
  }
  else{
    DPT_Field * e = new DPT_Field(_dpt.c_str());
    fields.insert(make_pair("dpt", (Field *) e));
  }
}

void Predicate::set_dpt(int _dpt)
{
  DPT_Field * d = new DPT_Field(_dpt);
  fields.insert(make_pair("dpt", (Field *) d));    
}

void Predicate::set_dpt(const Port_Field &_dpt)
{
  DPT_Field * d = new DPT_Field(_dpt);
  fields.insert(make_pair("dpt", (Field *)d));    
}


Predicate::Predicate(std::string strn)
{
  const string delims(" \t,;");
  vector<string> tokens;
  Tokenize(strn, tokens);
	set_proto(tokens[0]);
	
 	if (isAnyProto() ){
		set_sip(tokens[1]);
		//		set_spt(tokens[2]);
		set_dip(tokens[2]);
		//set_dpt(tokens[4]);
 	}

 	else if (isICMP()){
 		set_sip(tokens[1]);
 		set_dip(tokens[2]);
 		set_icmptype(tokens[3]);
 	}
 	else if (isUDP() || isTCP()){
 		set_sip(tokens[1]);
		set_spt(tokens[2]);
		set_dip(tokens[3]);
		set_dpt(tokens[4]);
 	}
  _bdd = toBDD();
}



Predicate::Predicate(const u_char * packet)
{
  struct ip * ippkt;
  unsigned int hdr_len;
  struct udphdr * udppkt;
  struct tcphdr * tcppkt;
  struct icmp *icmppkt;

  //ippkt = (struct ip *) (packet+14);

  ippkt = (struct ip *) (packet);

  
  set_sip(CIDR(ippkt->ip_src));
  set_dip(CIDR(ippkt->ip_dst));

  hdr_len = (ippkt->ip_hl) << 2 ;
  switch(ippkt->ip_p){
  case 17:
    udppkt = (struct udphdr *) (packet+ hdr_len); 
    set_spt(udppkt->source);
    set_dpt(udppkt->dest);
    break;
  case 6:
    tcppkt = (struct tcphdr *) (packet+hdr_len);
    set_spt(tcppkt->source);
    set_dpt(tcppkt->dest);
    break;
  case 1:
    icmppkt = (struct icmp *) (packet+hdr_len);
    set_icmptype(icmppkt->icmp_type);
    break;
  default:
    break;
  }

  set_proto(ippkt->ip_p);
  _bdd = toBDD();
  
}

Predicate::Predicate(const Predicate &p): fields(p.fields)
{
  //  cout << "copy" << endl;
  _bdd = toBDD();
} 


Field * Predicate::getField(string _field)
{
  if(fields.find(_field)!=fields.end()){
    return fields[_field];
  }
  else{
    return NULL;
  }
}


string Predicate::getFieldString(string _field)
{
  Field * f = getField(_field);

  if (f !=NULL){
    return f->toString();
  }
  else{
    return "any";
  }
}



string Predicate::toString(){
  string res, temp;
  temp =  getFieldString("prt");

  res ="< "+temp+" ";
  if (temp != "1"){
    

    res += getFieldString("sip")+" ";
    temp = getFieldString("spt");
    if (temp != "any")
      res += temp+" ";
    res += getFieldString("dip")+" ";
    temp = getFieldString("dpt");
    if (temp != "any")
      res += temp;

  }
  else{
    res += getFieldString("sip")+" ";
    res += getFieldString("dip")+" ";
    res += getFieldString("icmp_type");
  }

    res +=" >";
  return res;
}


  
bdd Predicate::toBDD() {
    map<string, Field *>::iterator pos;
    bdd v = bddtrue;
    for (pos = fields.begin(); pos != fields.end(); ++pos){
      v = bdd_and(v, pos->second->_bdd);
    }
    return v;
}

int Predicate::current_zoom(string _dimension)
{
  Field *f = getField(_dimension);
  if(f==NULL)
    return 0;
  else{
    return f->current_zoom();
  }
}

bool Predicate::isFlow(FlowDef def)
{
    map<string, int>::iterator pos;
    for (pos = def.defmap.begin(); pos != def.defmap.end(); ++pos){
      //cout << pos->first << pos->second << endl;
      if(current_zoom(pos->first) < pos->second)
	return false;
    }
    return true;
}

