/* -*-	Mode:C++; c-basic-offset:2; tab-width:2; indent-tabs-mode:t -*- */
using namespace std;
#include "CIDR.h"
#include "math.h"


struct in_addr CIDR_MASK[] = {
#if __BYTE_ORDER == __LITTLE_ENDIAN
  {0x00000000},
  {0x00000080},
  {0x000000c0},
  {0x000000e0},
  {0x000000f0},
  {0x000000f8},
  {0x000000fc},
  {0x000000fe},
  {0x000000ff},
  {0x000080ff},
  {0x0000c0ff},
  {0x0000e0ff},
  {0x0000f0ff},
  {0x0000f8ff},
  {0x0000fcff},
  {0x0000feff},
  {0x0000ffff},
  {0x0080ffff},
  {0x00c0ffff},
  {0x00e0ffff},
  {0x00f0ffff},
  {0x00f8ffff},
  {0x00fcffff},
  {0x00feffff},
  {0x00ffffff},
  {0x80ffffff},
  {0xc0ffffff},
  {0xe0ffffff},
  {0xf0ffffff},
  {0xf8ffffff},
  {0xfcffffff},
  {0xfeffffff},
  {0xffffffff}
#endif
#if __BYTE_ORDER == __BIG_ENDIAN
  {0x00000000},
  {0x80000000},
  {0xc0000000},
  {0xe0000000},
  {0xf0000000},
  {0xf8000000},
  {0xfc000000},
  {0xfe000000},
  {0xff000000},
  {0xff800000},
  {0xffc00000},
  {0xffe00000},
  {0xfff00000},
  {0xfff80000},
  {0xfffc0000},
  {0xfffe0000},
  {0xffff0000},
  {0xffff8000},
  {0xffffc000},
  {0xffffe000},
  {0xfffff000},
  {0xfffff800},
  {0xfffffc00},
  {0xfffffe00},
  {0xffffff00},
  {0xffffff80},
  {0xffffffc0},
  {0xffffffe0},
  {0xfffffff0},
  {0xfffffff8},
  {0xfffffffc},
  {0xfffffffe},
  {0xffffffff}
#endif
};

CIDR::CIDR(const char * strn="0.0.0.0/0")
{
  assert(strn!=NULL);
  char *ip, *masklen, *temp;
  int res;
  char * saveptr;
  //temp = strn;
  temp = strdup(strn);

  ip = strtok_r(temp, "/", &saveptr);
  if(ip!=NULL){
    res = inet_aton(ip, &(addr));
  }
  if (res ==0 or ip==NULL){
    inet_aton("127.0.0.1", &(addr));
  }

  masklen = strtok_r(NULL, "/", &saveptr);  
  if(masklen==NULL){
    mask = CIDR_MASK[32];
  }
  else{
    unsigned short t = atoi(masklen);
    assert(t<=32);
    mask = CIDR_MASK[t];
  }

  // delete[] temp;
}


CIDR::CIDR(const char * str_addr, const char * str_mask, bool isMask)
{
  assert(str_addr!=NULL);
  assert(str_mask!=NULL);
  //char * ip, *masklen, *temp;
  int res;

  res = inet_aton(str_addr, &(addr));
  if (res ==0){
    inet_aton("127.0.0.1", &(addr));
  }

  res = inet_aton(str_mask, &(mask));
  if(! isMask){
    mask.s_addr = ~ (mask.s_addr);
  }

  if (res == 0){
      mask = CIDR_MASK[32];
  }
  

}


CIDR::CIDR(const char * str_addr, int mask_len)
{
  int res;

  res = inet_aton(str_addr, &(addr));
  if (res ==0){
    inet_aton("127.0.0.1", &(addr));
  }

  mask = CIDR_MASK[mask_len];
}



/*should try to use operator overloading */
std::string CIDR::toString()
{
  
  sprintf(strn, "%s/%d", inet_ntoa(addr), bitcount(mask.s_addr));
  return std::string(strn);
}



list<CIDR> CIDR::subnets(int masklen)
{
  //enumerate subnets with sublen mask length
  list<CIDR> res;

  //cout << bitcount(mask.s_addr)<< endl;


  int lenif =masklen - bitcount(mask.s_addr);
 
  for (int i=0;i<pow(2, lenif);i++){
    struct in_addr a;
    a.s_addr = net().s_addr+ntohl((i<<(32-masklen)));
    CIDR x = CIDR(a, CIDR_MASK[masklen]);
    res.push_back(x);
  }

  return res;
}

CIDR CIDR::supernet(int masklen)
{
  struct in_addr naddr;
  naddr.s_addr = (addr.s_addr & CIDR_MASK[masklen].s_addr);
  CIDR x = CIDR(naddr, CIDR_MASK[masklen]);
  return x;
}


    


// int main()
// {
//   //CIDR x,y;
//   CIDR x = CIDR("202.8.95.4", "255.255.255.0");
//   CIDR y = CIDR("0.0.0.0/0");

//   in_addr a;

//   CIDR z = CIDR("202.8.95.4", "0.0.0.255", false); 
//   cout << x.toString() <<endl;
//   cout << y.toString() << endl;
//   cout << z.toString() << endl;
//   string a = inet_ntoa( x.net());
//   string b = inet_ntoa(x.broadcast());
//   cout<< a<<":"<< b << endl;


//   list<CIDR>::iterator it;

//   list<CIDR> l = y.subnets(2);

//   for(it=l.begin();it!= l.end();++it){
//     cout << it->toString() << endl;
//   }

//   cout << x.supernet(8).toString()<<endl;

//}
