/* -*-	Mode:C++; c-basic-offset:2; tab-width:2; indent-tabs-mode:t -*- */
#ifndef __FIREMAN_ACL_H
#define __FIREMAN_ACL_H 1

#include <list>
#include <string>
#include <set>
#include <map>
#include "bdd.h"
#include "Predicate.h"
#include "Rule.h"
using namespace std;

/**
 * bdd defaults to bddfalse
 */

typedef map<std::string, bdd> ACLState;
class ACL {
public:
  std::string name;
  list<Rule> rules;
  bool policy;



	bdd InputSpace;
	set<string> deps;
	map<string, bdd> transFunc;
	bool knownTF;


	ACL():  name("hell"), policy(false), knownTF(false) {}
  ACL(string _name):  name(_name), policy(false), knownTF(false) {
		cout << "ACl name "<< name<< endl;
	}
  ~ACL() {rules.clear();};
  void push_back(Rule p){rules.push_back(p);}
  string toString();
  string toString(int count);
  string toString(string fmt);
  void setPolicy(bool accept=false);

	set<string> dependency();

/**
 *  This is to avoid repeated travesal of a chain
 *  Can be called only by chains with no dependencies
 *  We are not checking yet. 
 **/
	template<typename FIREWALL>
	void transferFunction(FIREWALL & f)
	{
		//avoid repeated calculation
		if(! knownTF) {
			cout << "determine transfer function for "<< name<< endl;
			//transFunc = ACLState();
			transFunc["remain"]=bddtrue;
			list<Rule>::iterator pos;
			for (pos = rules.begin(); pos != rules.end(); ++pos){
				f.StateUpdate(transFunc, *pos);
			}	
			transFunc["return"] =  bdd_or(transFunc["remain"], transFunc["return"]);
			transFunc.erase("remain");
			knownTF=true;
		}
	}

	bool unionInputSpace(bdd i)
	{
		if (bdd_imp(i, InputSpace)==bddtrue){
			return false;
		}
		else{
			InputSpace = bdd_or(i, InputSpace);
			return true;
		}
	}
};


#endif
