#include <iostream>
#include <fstream>
//#include <ifstream>
#include <string>
#include "FireBase/ACL.h"
#include "FireBase/Predicate.h"
#include "bdd.h"

/**
 *  I expect the blacklist is a list of predicates
 *  we store the blacklist in an ACL
 */

using namespace std;

bdd getBlackList(string fname, ACL &acl)
{
  bdd res = bddfalse;
  ifstream fs; // "input file stream"
  string line;
  fs.open(fname.c_str());
  if (fs.fail()){
    cerr << "Couldn't open file " << fname << endl;
  }
  Predicate p;
  Rule r;
  while (true) {
    getline(fs, line);
    if (fs.fail()) break; // no more lines to read
    p = Predicate(line);

    res = bdd_or(res, p.toBDD());
    r = Rule("deny", p);
    //cout << r.toString()<< endl;
    acl.push_back(r);
  }
  fs.close();

  return res;
}
