#ifndef __CPP_InfoBase_H
#define __CPP_InfoBase_H 1
#include <map>
#include <list>
#include <string>
#include <iostream>
#include <stdlib.h>
#include <errno.h>
using namespace std;
map< string, int> getProtoMap(const char *fname); 
map< string, int> getPortMap(const char *fname, const char *proto);
pair<map< string, int>,map< string, int> > getPortMap(const char *fname);

list< string> getBogonList(const char *fname);
//map<string, int> getICMPTypeMap();

class InfoBase{


public:
  map<string, int> TCPPortMap;
  map<string, int> UDPPortMap;
  map<string, int> ProtoMap;
  map<string, int> ICMPTypeMap;
  list<string> BogonList;
  //constructor
  InfoBase(){}
  InfoBase(string protoname, string portname, string bogonname) {
    setProtoMapFile(protoname);
    setPortMapFile(portname);
    setBogonListFile(bogonname);
    setICMPTypeMap();
  }

  void setProtoMapFile(string fname) {
    ProtoMap = getProtoMap(fname.c_str());}
  void setPortMapFile(string fname) {
    pair<map<string, int>, map<string, int> > p;
    p = getPortMap(fname.c_str());
    TCPPortMap=p.first;
    UDPPortMap= p.second;
  }

  void setBogonListFile(string fname) {
    BogonList = getBogonList(fname.c_str());
  }

  void setICMPTypeMap();

  int getPortByName(string name, string proto); 
  int getPortByName(string name) {return getPortByName(name, 6);}
  int getPortByName(string name, int proto);
  int getProtoByName(string name) {
    int (*pf)(int)=tolower; 
    transform(name.begin(), name.end(), name.begin(), pf);
    return ProtoMap[name];
  }
};




#endif
