#include <iostream>
#include "InfoBase.h"

using namespace std;

int InfoBase::getPortByName(string name, string proto) 
{
  int val = -1;
  char *endp;
  char *s = (char *) name.c_str();
  val = strtol(s, &endp, 10);
  if(s!=endp && *endp=='\0'){
    //printf("port name = %s, val=%d\n", s, val);
    return val;
  }
  

  if (proto=="TCP" | proto=="tcp"){
    val = getPortByName(name, 6);
  }
  else if (proto=="UDP"| proto=="udp"){
    val = getPortByName(name, 17);
    }
  else {
    cout << "No port number mapping info for protocol " << proto<< endl;
    exit(-1);
  }
  
  if(val ==0){
    cout << "No port number found in standard infobase for "<< name<< endl;
    exit(-1);
  }
  
  return val;
}

int InfoBase::getPortByName(string name, int proto)
{  
  int val=-1;
  char *endp;
  char *s = (char *) name.c_str();
  val = strtol(s, &endp, 10);
  if(s!=endp && *endp=='\0'){
    //printf("port name = %s, val=%d\n", s, val);
    return val;
  }

  if (proto==6){
    val = TCPPortMap[name];
  }
  else if (proto==17){
    val = UDPPortMap[name];
  }
  else{
    exit(-1);
  }
 return val; 
} 



void InfoBase::setICMPTypeMap()
{
  ICMPTypeMap.insert(make_pair("echo reply", 0));
  ICMPTypeMap.insert(make_pair("echo-reply", 0));
  ICMPTypeMap.insert(make_pair("destination unreachable", 3));
  ICMPTypeMap.insert(make_pair("unreachable", 3 ));
  ICMPTypeMap.insert(make_pair("source quench", 4));
  ICMPTypeMap.insert(make_pair("source-quench", 4));

  ICMPTypeMap.insert(make_pair("redirect", 5));
  ICMPTypeMap.insert(make_pair("echo", 8));
  ICMPTypeMap.insert(make_pair("time exceeded", 11));
  ICMPTypeMap.insert(make_pair("time-exceeded", 11));
  ICMPTypeMap.insert(make_pair("traceroute", 11));
  ICMPTypeMap.insert(make_pair("parameter problem", 12));
  ICMPTypeMap.insert(make_pair("parameter-problem", 12));

  ICMPTypeMap.insert(make_pair("timestamp", 13));
  ICMPTypeMap.insert(make_pair("timestamp reply", 14)); 
  ICMPTypeMap.insert(make_pair("information request", 15));
  ICMPTypeMap.insert(make_pair("information-request", 15));

  ICMPTypeMap.insert(make_pair("information reply", 16));
  ICMPTypeMap.insert(make_pair("information-reply", 16));
}




// access-list 149 deny icmp any any information-request
// access-list 149 deny icmp any any information-reply
// access-list 149 deny icmp any any redirect

// int InfoBase::getICMPTypeByName(string n)
// {
//   val = ICMPTypeMap[name];
 
// }
