%{  
#include <string.h>
#include "InfoBase.h"
#include "BogonParse.tab.h"
  //  int bogonlineno =1;
%}

/*%option reentrant */

/* no wrapping is needed; setting this means we don't have to link with libfl.a */
%option noyywrap

/* don't use the default-echo rules */
 //%option nodefault

/* I don't call unput */
%option nounput


/* use the "fast" algorithm with no table compression */
%option full

/* utilize character equivalence classes */
%option ecs

/* the scanner is never interactive */
%option never-interactive

%option prefix="bogon"
%option outfile="lex.bogon.c"   

   /*%option yylineno*/

/* caseless matching */
%option caseless



ws            ([ \t]*)
nl            (\n)
Eight_Bit     ([0-9]|[1-9][0-9]{1,2}|(2[0-4][0-9])|(25[0-5]))
SIXTEEN       ([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])
IPAddr        ({Eight_Bit}[\.]{Eight_Bit}[\.]{Eight_Bit}[\.]{Eight_Bit})
MASK          ([0-9]|([1-2][0-9])|(3[0-2]))
CIDR          ({IPAddr}[/]{MASK})


%%
{ws} ;
{nl}  {return nl;}
{CIDR} {bogonlval.strn = strdup(yytext);return CIDR;}


%% 

void bogonerror(char *v)
{
  printf("%s:\n", v);
}


// int bogonwrap(){
//   return 1;
// }

