/* -*-	Mode:C++; c-basic-offset:2; tab-width:2; indent-tabs-mode:t -*- */
#ifndef __CPP_nfFIREWALL_H_
#define __CPP_nfFIREWALL_H_ 1
#include <set>
#include <map>
#include <string>
#include <boost/config.hpp>
#include <boost/graph/subgraph.hpp>
#include <boost/graph/adjacency_list.hpp>
#include <boost/graph/graph_utility.hpp>
#include <boost/graph/properties.hpp>
#include <boost/graph/graphviz.hpp>



#include "bdd.h"
#include "FireBase/ACL.h"
#include "FireBase/Util.h"
#include "Policy/Policy.h"
#include "Firewall.h"




namespace boost{
	template<typename Graph>
	typename graph_traits < Graph >::vertex_descriptor
	getVertexbyName(string _name,  Graph & g)
	{
		typename Graph::vertex_iterator vi, vi_end;
		
		typename property_map < Graph, vertex_name_t >::type  
			name_map = get(vertex_name, g);
		
		for (tie(vi, vi_end) = vertices(g); vi != vi_end; ++vi) {
			//cout << name_map[*vi] << endl;
			if (name_map[*vi]== _name){
				return *vi;
			}
		}
		return NULL;
	}

	typedef boost::adjacency_list<vecS, vecS, directedS,
																property<vertex_name_t, string>,
																property<edge_weight_t, double>
	> Graph;
	typedef graph_traits<Graph>::vertex_descriptor Vertex;
	typedef graph_traits<Graph>::edge_descriptor Edge;

}

/**
 *  Class of netfilter (iptables) firewall currently, we worry about
 *  "filter" table only tables "nat", "mangle" and "raw" are not
 *  supported
 **/
class nfFirewall : public Firewall
{
 public: 
  //std::map<string, ACL> acls;

  nfFirewall()
	{
    defaultChains();
  }

  nfFirewall(string fname, bool isFile=true);

  void delChain(string chain="all")
	{
    if(chain=="all"){
      acls.clear();
    }
    else{
      acls.erase(chain);
    }
  }

//   void polChain(string name, string policy)
// 	{
		

//     if (policy== "ACCEPT"){
//       acls[name].setPolicy(true);
//     }
//     else if (policy=="REJECT"){
		 
//       acls[name].setPolicy(false);
//     }
//   }


  void defaultChains(string tableName="filter")
	{
    if (tableName =="filter"){
      newACL("INPUT"); 
      newACL("FORWARD");
      newACL("OUTPUT");
    }
    else if (tableName=="nat"){
      newACL("PREROUTING");
      newACL("POSTROUTING");
    }
    else if (tableName=="all"){
      newACL("INPUT"); 
      newACL("FORWARD");
      newACL("OUTPUT");
      newACL("PREROUTING");
      newACL("POSTROUTING");
    }
 }

  void dependencyGraph();

  Rule * getRule(string s);


	void contextAnalysis();

	void StateUpdate(ACLState & state, Rule r);
	void initInputSpace();
	void policyCheck(ACL & acl);

};










#endif
