%{
#include <stdio.h>
#include <iostream>
#include "fwPIXParse.tab.h"
#include "FireBase/CIDR.h"
using namespace std;
int pixlineno=1;
//char linebuf[500];
%}
/*%option reentrant */

/* no wrapping is needed; setting this means we don't have to link with libfl.a */
%option noyywrap

/* don't use the default-echo rules */
 //%option nodefault

/* I don't call unput */
%option nounput

/* generate a c++ lexer */
 /*%option c++*/


/* use the "fast" algorithm with no table compression */
%option full

/* utilize character equivalence classes */
%option ecs

/* the scanner is never interactive */
%option never-interactive

%option prefix="fwPIX"
%option outfile="lex.fwPIX.c"   

   /*%option yylineno*/

/* caseless matching */
%option caseless


ALPHAS        ([a-zA-Z]*)
DIGIT         ([0-9])
ws            ([ \t]*)
ANY           (any|ANY|\*)
nl            (\n)
ACCEPT     (permit|PERMIT|accept|ACCEPT)
DENY       (deny|drop|DENY|DROP)


dotMask32      (255[\.]255[\.]255[\.]255)
dotMask31      (255[\.]255[\.]255[\.]254) 
dotMask30      (255[\.]255[\.]255[\.]252) 
dotMask29      (255[\.]255[\.]255[\.]248)
dotMask28      (255[\.]255[\.]255[\.]240)
dotMask27      (255[\.]255[\.]255[\.]224) 
dotMask26      (255[\.]255[\.]255[\.]192) 
dotMask25      (255[\.]255[\.]255[\.]128) 

dotMaskD       ({dotMask32}|{dotMask31}|{dotMask30}|{dotMask29}|{dotMask28}|{dotMask27}|{dotMask26}|{dotMask25})

dotMask24      (255[\.]255[\.]255[\.]0) 
dotMask23      (255[\.]255[\.]254[\.]0) 
dotMask22      (255[\.]255[\.]252[\.]0) 
dotMask21      (255[\.]255[\.]248[\.]0) 
dotMask20      (255[\.]255[\.]240[\.]0)
dotMask19      (255[\.]255[\.]224[\.]0) 
dotMask18      (255[\.]255[\.]192[\.]0) 
dotMask17      (255[\.]255[\.]128[\.]0) 

dotMaskC       ({dotMask24}|{dotMask23}|{dotMask22}|{dotMask21}|{dotMask20}|{dotMask19}|{dotMask18}|{dotMask17})


dotMask16      (255[\.]255[\.]0[\.]0)
dotMask15      (255[\.]254[\.]0[\.]0) 
dotMask14      (255[\.]252[\.]0[\.]0) 
dotMask13      (255[\.]248[\.]0[\.]0) 
dotMask12      (255[\.]240[\.]0[\.]0) 
dotMask11      (255[\.]224[\.]0[\.]0) 
dotMask10      (255[\.]192[\.]0[\.]0) 
dotMask9      (255[\.]128[\.]0[\.]0) 

dotMaskB       ({dotMask16}|{dotMask15}|{dotMask14}|{dotMask13}|{dotMask12}|{dotMask11}|{dotMask10}|{dotMask9})


dotMask8      (255[\.]0[\.]0[\.]0)
dotMask7      (254[\.]0[\.]0[\.]0) 
dotMask6      (252[\.]0[\.]0[\.]0) 
dotMask5      (248[\.]0[\.]0[\.]0) 
dotMask4      (240[\.]0[\.]0[\.]0) 
dotMask3      (224[\.]0[\.]0[\.]0) 
dotMask2      (192[\.]0[\.]0[\.]0) 
dotMask1      (128[\.]0[\.]0[\.]0) 
dotMask0      (0[\.]0[\.]0[\.]0) 
dotMaskA       ({dotMask8}|{dotMask7}|{dotMask6}|{dotMask5}|{dotMask4}|{dotMask3}|{dotMask2}|{dotMask1}|{dotMask0})

DotMask      ({dotMaskA}|{dotMaskB}|{dotMaskC}|{dotMaskD})




dotWild1      (0[\.]0[\.]0[\.]1)
dotWild2      (0[\.]0[\.]0[\.]3)
dotWild3      (0[\.]0[\.]0[\.]7)
dotWild4      (0[\.]0[\.]0[\.]15)
dotWild5      (0[\.]0[\.]0[\.]31)
dotWild6      (0[\.]0[\.]0[\.]63)
dotWild7      (0[\.]0[\.]0[\.]127)
dotWild8      (0[\.]0[\.]0[\.]255)

dotWildA       ({dotWild8}|{dotWild7}|{dotWild6}|{dotWild5}|{dotWild4}|{dotWild3}|{dotWild2}|{dotWild1})


dotWild9      (0[\.]0[\.]1[\.]255)
dotWild10      (0[\.]0[\.]3[\.]255)
dotWild11      (0[\.]0[\.]7[\.]255)
dotWild12      (0[\.]0[\.]15[\.]255)
dotWild13      (0[\.]0[\.]31[\.]255)
dotWild14      (0[\.]0[\.]63[\.]255)
dotWild15      (0[\.]0[\.]127[\.]255)
dotWild16      (0[\.]0[\.]255[\.]255)

dotWildB       ({dotWild16}|{dotWild15}|{dotWild14}|{dotWild13}|{dotWild12}|{dotWild11}|{dotWild10}|{dotWild9})

dotWild17      (0[\.]1[\.]255[\.]255)
dotWild18      (0[\.]3[\.]255[\.]255)
dotWild19      (0[\.]7[\.]255[\.]255)
dotWild20      (0[\.]15[\.]255[\.]255)
dotWild21      (0[\.]31[\.]255[\.]255)
dotWild22      (0[\.]63[\.]255[\.]255)
dotWild23      (0[\.]127[\.]255[\.]255)
dotWild24      (0[\.]255[\.]255[\.]255)

dotWildC       ({dotWild24}|{dotWild23}|{dotWild22}|{dotWild21}|{dotWild20}|{dotWild19}|{dotWild18}|{dotWild17})


dotWild25      (1[\.]255[\.]255[\.]255)
dotWild26      (3[\.]255[\.]255[\.]255)
dotWild27      (7[\.]255[\.]255[\.]255)
dotWild28      (15[\.]255[\.]255[\.]255)
dotWild29      (31[\.]255[\.]255[\.]255)
dotWild30      (63[\.]255[\.]255[\.]255)
dotWild31      (127[\.]255[\.]255[\.]255)
dotWild32      (255[\.]255[\.]255[\.]255)


dotWildD       ({dotWild32}|{dotWild31}|{dotWild30}|{dotWild29}|{dotWild28}|{dotWild27}|{dotWild26}|{dotWild25})


DotWild      ({dotWildA}|{dotWildB}|{dotWildC}|{dotWildD})

Eight_Bit     ([0-9]|[1-9][0-9]{1,2}|(2[0-4][0-9])|(25[0-5]))
NUMBER        ([0-9]|[1-9][0-9]+)


DotAddr        ({Eight_Bit}[\.]{Eight_Bit}[\.]{Eight_Bit}[\.]{Eight_Bit})
MASK          ([0-9]|([1-2][0-9])|(3[0-2]))
CIDR          ({DotAddr}[/]{MASK})
HOST         (host|HOST)
EQ            (eq|EQ)

ICMP         (icmp)
PORTNAME     (ssh|ftp|domain|smtp|www|ftp-data|https|isakmp|telnet|ldap|echo|traceroute|ident|ntp|syslog|radius)
ICMPType      (echo|traceroute)
PARTITION     (partition)



IGNORE    ^(PIX|enable|passwd|domain-name|hostname|logging|mtu|ip|failover|pdm|arp|aaa|timeout|snmp|floodguard|telnet|ssh|console|terminal|crypto|no|pager|global|nat|static|interface|nameif|fixup|access-group|route|vpngroup).*$

END          ([:]{ws}end)
WORD         ([^ \t\n]*)

%%


{ws} ;
{nl}     {pixlineno++;return nl;}
{IGNORE} ;
{ACCEPT} {return cACCEPT;}
{DENY}   {return cDENY;}
{ANY}    {fwPIXlval.strn=strdup("any");return ANY;}
{HOST}    {return cHOST;}
{CIDR}   {fwPIXlval.strn=strdup(yytext); return CIDRAddr;}
{DotMask} {fwPIXlval.strn=strdup(yytext);return DotMask;}
{DotWild}  {fwPIXlval.strn=strdup(yytext);return DotWild;}
{DotAddr} {fwPIXlval.strn=strdup(yytext); return DotAddr;}
{ICMP}    {return ICMP;}
{ICMPType} {fwPIXlval.strn=strdup(yytext);return ICMPType;}
{PORTNAME} {fwPIXlval.strn=strdup(yytext);return PORTNAME;}
(access-list) {return cACL;}
{EQ}      {return cEQ;}
{NUMBER}  {fwPIXlval.strn=strdup(yytext);return NUMBER;}
(enable)    {printf("enable\n"); return cENABLE;}
(passwd)    {printf("passwd\n"); return cPASSWD;}
(range) {return cRANGE;}
(gt) {return cGT;}
{WORD} {fwPIXlval.strn=strdup(yytext);return WORD;}
%%

void fwPIXerror(char *v)
{
  printf("line %d: %s\n", pixlineno, v);

}

//PROTO     (udp|tcp|esp|ip|ah)
//{PROTO}  {fwPIXlval.strn=strdup(yytext);return PROTO;}

// int fwPIXwrap(){
//   return 1;
// }

