%{
#include <stdio.h>
#include <iostream>
#include "fwIPTParse.tab.h"
#include "FireBase/CIDR.h"

  namespace IPTParse{
    int lineno=1;
  }
  using namespace IPTParse;
%}
%option noyywrap

%option nounput
%option full
%option ecs
%option never-interactive
/*%option nodefault*/

%option prefix="fwIPT"
%option outfile="lex.fwIPT.c"   
   /*%option caseless*/


ALPHAS        ([a-zA-Z]*)
DIGIT         ([0-9])
ws            ([ \t]*)
QWORD         (\"[a-zA-Z0-9 :\.]*\")
COMMA         ([,])
dash          (\-)
cnt         (\\)(\n)
nl            (\n)
EQ           ([\=])
nWORD          ([^ \t\n\"=\$]*)
COMMENT      ^([#]).*$
INVERT        (!)
DOLLAR        (\$)

cAPPEND     (\-A)|(\-\-append)
cDELETE     (\-D)|(\-\-delete)
cINSERT     (\-I)|(\-\-insert)
cLIST       (\-L)|(\-\-list)
cFLUSH       (\-F)|(\-\-flush)
cZERO       (\-Z)|(\-\-zero)
cNEW        (\-N)|(\-\-new)
cPOLICY     (\-P)|(\-\-policy)

cPROTO        (\-p)|(\-\-proto)
cSRC        (\-s)|(\-src)|(\-\-source)
cDST        (\-d)|(\-dst)|(\-\-destination)
cIN     (\-\-in\-interface)|(\-i)
cJUMP       (\-j)|(\-\-jump)
cGOTO    (\-g)|(\-\-goto)
cMATCH     ((\-m)|(\-\-match))
cNUMERIC  (\-\-numeric)|(\-n)
cOUT     (\-\-out\-interface)|(\-o)
cTABLE      (\-t)|(\-\-table)



cDPORT       (\-\-dport)|(\-\-destination\-port)
cSPORT       (\-\-sport)|(\-\-source\-port)
cICMP_TYPE    (\-\-icmp\-type)
cSTATE       (\-\-state)
STATES       (ESTABLISHED)|(RELATED)|(NEW)
cTCPFLAG     (\-\-tcp\-flags)
TCPFLAG      ((SYN)|(ACK)|(FIN)|(RST)|(URG)|(PSH)|(\-\-syn))
cREJECT_WITH (\-\-reject\-with)

cLIMIT       (\-\-limit)
cLIMIT_BURST  (\-\-limit\-burst)
cLOG_PREF    (\-\-log\-prefix)
cLOG_LEVEL    (\-\-log\-level)
cTO_SOURCE (\-\-to\-source)








IPTABLES (\$IPTABLES)

%%

{COMMENT} {}
{QWORD} {fwIPTlval.strn = strdup(yytext); return QWORD;}
{COMMA}  {return COMMA;}
{cnt}    {lineno++;};
{EQ}     {return EQ;}

{INVERT} {return INVERT;}

{IPTABLES} {return IPTABLES;}


{cAPPEND} {return cAPPEND;}
{cDELETE} {return cDELETE;} 
{cINSERT} {return cINSERT;}
{cLIST}   {return cLIST;}
{cFLUSH}  {return cFLUSH;}
{cZERO}   {return cZERO;}
{cNEW}    {return cNEW;}
{cPOLICY} {return cPOLICY;}
{cPROTO}  {return cPROTO;}
{cSRC}    {return cSRC;}
{cDST}    {return cDST;}
{cIN}     {return cIN;}
{cJUMP}   {return cJUMP;}
{cGOTO}   {return cGOTO;}
{cMATCH}  {return cMATCH;}
{cNUMERIC} {return cNUMERIC;}
{cOUT}     {return cOUT;}
{cTABLE}  {return cTABLE;}

{cDPORT}  {return cDPORT;}
{cSPORT}  {return cSPORT;}
{cICMP_TYPE} {return cICMP_TYPE;}
{cSTATE}  {return cSTATE;}
{cTCPFLAG} {return cTCPFLAG;}
{TCPFLAG} {return TCPFLAG;}
{cREJECT_WITH} {return cREJECT_WITH;}

{cLIMIT_BURST} {return cLIMIT_BURST;}
{cLIMIT} {return cLIMIT;}
{cLOG_PREF} {return cLOG_PREF;}
{cLOG_LEVEL} {return cLOG_LEVEL;}
{cTO_SOURCE} {return cTO_SOURCE;}


{ws} ;
{nl}     {lineno++;return nl;}

\$ {return DOLLAR;}
{nWORD} {fwIPTlval.strn=strdup(yytext);return nWORD;}
.  ECHO;

%%

void fwIPTerror(char *v)
{
  printf("line %d: %s\n", lineno, v);
}


//{DOLLAR} {cout << "dollar "<< yytext<< endl;return DOLLAR;}
// {BUILTIN_CHAIN} {
//   fwIPTlval.strn = strdup(yytext);
//   return BUILTIN_CHAIN;}
//TARGET    (ACCEPT|DROP|LOG)
// {TARGET} {  
//   fwIPTlval.strn = strdup(yytext);
//   return TARGET;}
