/* -*-	Mode:C++; c-basic-offset:2; tab-width:2; indent-tabs-mode:t -*- */
#ifndef __CPP_FIREMAN_H
#define __CPP_FIREMAN_H 1

/**
 * actual ACL checking algorithm, using template
 **/

#include <string>
#include <ostream>
#include <sstream>
#include "FireBase/FireBase.h"
#include "FireBase/bddutil.h"
#include "Policy/Policy.h"
#include "config.h"

using namespace std;

/**
 * forward check algorithm described in the paper 
 */
template <typename xACL, typename FIREWALL>
int intra_ACL_check(xACL &acl, 
										FIREWALL &fw, 
										ostream & out, 
										string type=string("PIX"))
{

  //out << "intra ACL check on " << acl.name << endl;
  list<Rule>::iterator pos;
  ACLState state;
	//cout << acl.InputSpace<< endl;
	state["remain"]=acl.InputSpace;
  int i=1;
  for (pos = acl.rules.begin(); pos != acl.rules.end(); ++pos){
    //out << "rule " << i << ": "<< pos->pred->toString()<< endl;
    out << i <<" "<< pos->toString() << "==> ";
    switch (CompareBDD(pos->toBDD(), state["remain"])){
    case SUBSET:
    case EQUAL:
      out << " good " ;
      break;

    case DISJOINT:
      //out << "" << endl;
      out << "Error :: masked rule : ";
			if (CompareBDD(pos->toBDD(), acl.InputSpace)== DISJOINT){
				out << "masked by context " ;
				//(this rule does not match any packet due input) 
			}

      if (pos->target=="accept"){
				if(CompareBDD(pos->toBDD(), state["accept"])==SUBSET
					 ||CompareBDD(pos->toBDD(), state["accept"])==EQUAL)
					{
						out << "forward redundancy";
					}
				else if(CompareBDD(pos->toBDD(), state["deny"])==SUBSET
								||CompareBDD(pos->toBDD(), state["deny"])==EQUAL)
					{
						out << "shadowing";
					}
				else {
					out << " redundancy and correlation";
				}
				if (DEBUG_TRACE){
					forwardTrace(acl, *pos, i, out);
				}
				break;
      }
			
      else if (pos->target=="deny"){
				if(CompareBDD(pos->toBDD(), state["accept"])==SUBSET
					 ||CompareBDD(pos->toBDD(), state["accept"])==EQUAL)
					{
						out << "shadowing";
						break;
					}
				else if(CompareBDD(pos->toBDD(), state["deny"])==SUBSET
								||CompareBDD(pos->toBDD(), state["deny"])==EQUAL)
					{
						out << "forward redundancy";
						break;
					}
				else {
					out << "redundancy and correlation";
				}
      }
			
      else if (pos->target=="forward"){
				out << "unreachable rule"<< endl;
				break;
      }
 
    case SUPERSET:
      //out << "this must be the last effective rule" << endl;
      break;
    case OVERLAP:
      out << "WARNING:: partially masked rule : ";
      
      if (pos->target=="accept"){
				if(CompareBDD(pos->toBDD(), state["deny"])==OVERLAP)
					{
						out << "correlation";
					}
				else{
					out << "OK, previous rule accepted some";
				}
      }

      else if (pos->target=="deny"){
				if(CompareBDD(pos->toBDD(), state["accept"])==OVERLAP)
					{
						out << "correlation";
					}
				else{
					out << "OK, previous rule dropped some";
				}
      }
      break;
    default:
      out << "???"<< endl;
      exit(-1);
    }
		fw.StateUpdate(state, *pos);
    ++i;
    out << endl;
  }

	if(state["remain"]==acl.InputSpace){
		cout << "\nError:: this ACL does not match any input packets"<< endl;
	}

	
  return 0;
}

// template <typename xACL>
// int inter_ACL_check(bdd I, xACL &acl,  ostream & out)
// {

//   out << "inter ACL check on " << acl.name << endl;
//   list<Rule>::iterator pos;
//   ACLState state;
//   //int i=1;
//   for (pos = acl.rules.begin(); pos != acl.rules.end(); ++pos){
//     out << pos->toString() << "==> ";
//     if (pos->target=="accept"){
      
//       if (bdd_imp(pos->toBDD(), I)==bddtrue){
// 	    out << "good"<< endl;
//       }
//       else if (bdd_imp(pos->toBDD(), bdd_not(I))==bddtrue){
// 				out << "Error:: shadowing, unreachable accept" << endl;
//       }
//     }
//     else if (pos->target=="deny"){
//       if (bdd_imp(pos->toBDD(), I)==bddtrue){
// 	    out << "new deny, raising security level?"<< endl;
//       }
//       else if (bdd_imp(pos->toBDD(), bdd_not(I))==bddtrue){
// 				out << "redundancy, multiple line of defense?" << endl;
//       }
//     }
//   }
//   return 0;
// }


/** 
 * Check for backward redundancy (a preceding rule can be removed
 * without changing the action of the ACL)
 * 
 * My algorithm in the oakland paper is unnecessarily complicated.
 *
 * Checking for backward redundancy can be achieved by a simple
 * reverse travesal of the ACL. Starting from <A=0, D=All> every rule
 * should change the AD set
 */


template <typename xACL, typename FIREWALL>
int reverse_traversal(xACL &acl, FIREWALL & fw, ostream & out)
{

  list<Rule>::reverse_iterator pos;
  
  map<std::string, bdd> state;
  
  if(acl.policy==false){
    state["accept"]=bddfalse;
    state["deny"]=bddtrue;
  }
  else{
    state["deny"]=bddfalse;
    state["accept"]=bddtrue;
  }

  int i = acl.rules.size()-1;
  
  for (pos = ++acl.rules.rbegin(); pos != acl.rules.rend(); ++pos){
    out << i << " " <<pos->toString() << " <== ";
    
    if (pos->target=="accept"){
      if (bdd_imp(pos->toBDD(), state["accept"])==bddtrue){
	    out << "backward redundancy";
	    backwardTrace(acl, *pos, i, out);
      }
      else {
	out << "OK";
      }
      state["accept"] = bdd_or(state["accept"], pos->toBDD());
      state["deny"] = bdd_and(state["deny"], bdd_not(pos->toBDD()));
    }
    else if(pos->target=="deny"){
      if (bdd_imp(pos->toBDD(), state["deny"])==bddtrue){
	    out << "backward redundancy";
	    backwardTrace(acl, *pos, i, out);
      }
      state["deny"] = bdd_or(state["deny"], pos->toBDD());
      state["accept"] = bdd_and(state["accept"], bdd_not(pos->toBDD()));
    }
    
    out << endl;
    i--;
  }
  return 0;
}


/**
 *  Find the debug trace, essentially enumerating all the preceding
 *  rules that's relatedss
 */

template <typename xACL>
int forwardTrace(xACL &acl, Rule & r, int cnt, ostream & out)
{
  list<Rule>::iterator pos;
  int i=1;
  out << "\n\t\t----------------------------------------------------";
  for (pos = acl.rules.begin(); pos != acl.rules.end(); ++pos){
    if (bdd_and(pos->toBDD(), r.toBDD())!=bddfalse){
      out << "\n\t\t " <<  i << " "<<pos->toString();
    }
    
    if(i>cnt) break;
    ++i;
  }
  out << "\n\t\t---------------------------------------------------";
  return 0;
}

/**
 *  Find the debug trace by enumerating all the following rules that's
 *  related
 */

template <typename xACL>
int backwardTrace(xACL &acl, Rule & r, int cnt, ostream & out)
{
  list<Rule>::reverse_iterator pos;
  int i = acl.rules.size();
  out << "\n\t\t-------------------------------------------------------";
  for (pos = acl.rules.rbegin(); pos != acl.rules.rend(); ++pos){
    if (bdd_and(pos->toBDD(), r.toBDD())!=bddfalse){
      out <<  "\n\t\t " << i << " "<<pos->toString();
    }
    if(i<=cnt) break;
    i--;
  }
  out << "\n\t\t---------------------------------------------------------";
  return 0;

}


// template <typename xChain>
// int funcAnalysis(xACL)
// {
//   list<Rule>::iterator pos;
//   for (pos = acl.rules.begin(); pos != acl.rules.end(); ++pos){
//     state.Update(*pos);
// 	}	
// }


#endif
