/* -*-	Mode:C++; c-basic-offset:2; tab-width:2; indent-tabs-mode:t -*- */
#ifndef __CPP_FIREWALL_H_
#define __CPP_FIREWALL_H_ 1

#include <string>
#include <map>
#include "FireBase/ACL.h"
#include "FireBase/Util.h"
#include "InfoBase/InfoBase.h"

using namespace std;

//template<typename ACL>
class Firewall 
{
public:
	
  map<string, ACL> acls;
  multimap<string, string> itfs;
  string hostname;
  string domainname;
  string type;
  string version;

	string ownIP;  //check stealth rule

  static InfoBase *ib;

  Firewall() {}
	Firewall(const string&s, const string &format="PIX", bool isFile=true);
	void appendRule(string aclname, Rule &r) ;
	string toString();
	void setDefaultPolicy();
	void StateUpdate(ACLState & state, Rule & r); 

  void listACLs(string acl="all");
	void newACL(string name);

	void stealthCheck() {
		Predicate p= Predicate(); 
		p.set_dip(ownIP);

	};

};


#endif
