/* -*-	Mode:C++; c-basic-offset:2; tab-width:2; indent-tabs-mode:t -*- */

#include <iostream>
#include <fstream>
#include <stdexcept>
#include "Firewall.h"

using namespace std;


extern int parsePIX(Firewall *f, const char *s);


	
Firewall::Firewall(const string&s, const string &format, bool isFile)
{
	string data;
	if(isFile){
		data = readFile(s);
	}
	else{
		data = s;
	}
	
	if (format =="PIX"){  //cisco PIX
		parsePIX(this, data.c_str());
		setDefaultPolicy();
	}
	
	//   else if (format=="IPT"){ // linux iptables
	//     parseIPT(this, data.c_str());
	//   }
	
}



	
string Firewall::toString()
{
	map<string, ACL>::iterator it;
	string s = "";
	
	for(it=acls.begin();it != acls.end();++it){
		s+= it->second.toString(1);
	}
	return s;
}

void Firewall::setDefaultPolicy()
{
	map<string, ACL>::iterator it;
	for(it=acls.begin();it != acls.end();++it){
		it->second.setPolicy(it->second.policy);
	}
}
	

void Firewall::StateUpdate(ACLState & state, Rule & r) 
{
	assert (r.target != "remain");
	if(state.find(r.target)==state.end()){
		state[r.target] = bddfalse;
	}
	state[r.target] = bdd_or(state[r.target], r.pred.toBDD());
	state["remain"] = bdd_and(state["remain"], bdd_not(r.pred.toBDD()));  
}



void Firewall::listACLs(string acl)
{
	std::map<string, ACL>::iterator pos;
	for (pos= acls.begin();pos != acls.end();++pos){
		cout << pos->first << endl;
		cout << "=============" << endl;
		cout << pos->second.toString() << endl;
	}
}

void Firewall::newACL(string name)
{

	map<string, ACL>::iterator it = acls.find(name);
	if (it == acls.end()){
		acls.insert(make_pair(name, ACL(name)));
		it = acls.find(name);
	}
	
	it->second.InputSpace = bddtrue;
}

void Firewall::appendRule(string aclname, Rule &r) 
{
	if (aclname=="ACCEPT" || aclname=="DROP"){
		cout << "cannot append to builtin targets"<< endl;
		exit(-1);
	}

	map<string, ACL>::iterator it = acls.find(aclname);
	if (it == acls.end()){
		newACL(aclname);
		cout << "new acl " <<  aclname << " registered "<< endl;
		it = acls.find(aclname);
	}
	it->second.push_back(r);
}
	
