/* -*-	Mode:C++; c-basic-offset:2; tab-width:2; indent-tabs-mode:t -*- */
#ifndef __FIREMAN_BDDUTIL_H
#define __FIREMAN_BDDUTIL_H 1

#include <vector>
#include "bdd.h"
#include "bvec.h"
#include "CIDR.h"

enum BDDCOMP {
	EQUAL,
  SUBSET,
  SUPERSET,
  OVERLAP,
  DISJOINT
};

BDDCOMP CompareBDD(bdd a, bdd b);


bdd val2bdd(unsigned int val, int nbits, bvec V);
bdd interval2bdd(unsigned int min, unsigned int max, int nbits, bvec v);
bdd CIDR2bdd(CIDR *c, bvec bvecL);
bdd port2bdd(u_int16_t port, bvec bvecL);




#endif
