/* -*-	Mode:C++; c-basic-offset:2; tab-width:2; indent-tabs-mode:t -*- */

#include "bddutil.h"

bdd val2bdd(unsigned int val, int nbits, bvec V)
{
  bvec x = bvec_con(nbits, val);
  bdd res = bvec_equ(V, x);
  return res;
}

bdd interval2bdd(unsigned int min, unsigned int max, int nbits, bvec v)
{
  //  assert(min <= max);
  bvec x = bvec_con(nbits, min);
  bvec y = bvec_con(nbits, max);
  bdd a = bvec_gte(v, x);
  bdd b = bvec_lte(v, y);
  return bdd_and(a, b);
}


bdd CIDR2bdd(CIDR *c, bvec bvecL)
{
  int min = ntohl(c->net().s_addr);
  int max = ntohl(c->broadcast().s_addr);
  return interval2bdd(min, max, 32, bvecL);
}

bdd port2bdd(u_int16_t port, bvec bvecL)
{
  return val2bdd(ntohs(port), 16, bvecL);
}


BDDCOMP CompareBDD (bdd a, bdd b){
  if(a == b)
    return EQUAL;
  else if (bdd_imp(a, b)==bddtrue)
    return SUBSET;
  else if (bdd_imp(b, a)==bddtrue)
    return SUPERSET;
  else{
    bdd ovh = bdd_and(a, b);
    if (ovh==bddfalse){
      return DISJOINT;
    } else {
      return OVERLAP;
    }
  }
}
