/* -*-	Mode:C++; c-basic-offset:2; tab-width:2; indent-tabs-mode:t -*- */
#ifndef __FireBase_Predicate_H
#define __FireBase_Predicate_H 1

#include <arpa/inet.h>
//#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <string>
#include <map>
#include <list>
#include <vector>

#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/if_ether.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <netinet/ip_icmp.h>


#include "bdd.h"
#include "bvec.h"
#include "CIDR.h"
#include "Interval.h"
#include "bddutil.h"


using namespace std;

/*field is only defined to marry a specific type*/
class Field {
public:
  bdd _bdd;
  static std::map<std::string, bvec> sbm; 
  static void initMapping(int, int);
  Field(): _bdd(bddtrue) {}
  virtual ~Field() {};
  virtual bdd toBDD(bvec v)=0;
  virtual std::string toString()=0;// {return "any";}
  virtual int current_zoom()=0; 
};

class Val_Field: public Field {
public:
  int _val;
  int nbits;
  bdd toBDD(bvec v) {return val2bdd(_val, nbits, v);}
  std::string toString() {
    char t[10]; 
    snprintf(t, 10, "%d", _val);
    return string(t);
  }

  //  virtual bool isSingular()=0;

};



class CIDR_Field: public Field, public CIDR {
public:
  static int zoom_min;
  static int zoom_max;
  CIDR_Field():CIDR("0.0.0.0/0") {}
    ~CIDR_Field() {}
  CIDR_Field(const char * strn): CIDR(strn){
  }
  CIDR_Field(const char * addr, const char * mask): 
    CIDR(addr, mask) {}

  CIDR_Field(struct in_addr addr, struct in_addr mask): CIDR(addr, mask){}
  CIDR_Field(struct in_addr addr): CIDR(addr){}
  
  CIDR_Field(const CIDR &c){
    addr = c.addr;
    mask = c.mask;
//     toBDD();
  }
  
  bdd toBDD(bvec v);
  std::string toString() {return CIDR::toString();}

  int current_zoom() {return masklen();}
  
};


class SIP_Field: public CIDR_Field {
public:
  static std::string name;
  SIP_Field(): CIDR_Field() {
    _bdd = toBDD(sbm["sip"]);
  }
  SIP_Field(const char *strn): CIDR_Field(strn){
    _bdd = toBDD(sbm["sip"]);
  }
  SIP_Field(const char * addr, const char * mask): 
    CIDR_Field(addr, mask) {
    _bdd = toBDD(sbm["sip"]);
  }

  SIP_Field(const CIDR &c){
    //cout << "in SIP_Field " << c.toString()<<endl;
    addr = c.addr;
    mask = c.mask;
    _bdd = toBDD(sbm["sip"]);
  }

  SIP_Field(const SIP_Field & s) {
    addr = s.addr;
    mask = s.mask;
    _bdd = toBDD(sbm["sip"]);
  }
  
  list<SIP_Field> zoom_in(int nlevel);

};




class DIP_Field: public CIDR_Field {
public:
  static std::string name;
  DIP_Field(): CIDR_Field() {
        _bdd = toBDD(sbm["dip"]);
  }
  DIP_Field(const char *strn): CIDR_Field(strn){
    _bdd = toBDD(sbm["dip"]); 
  }
  DIP_Field(const char * addr, const char * mask): 
    CIDR_Field(addr, mask) {
    _bdd = toBDD(sbm["dip"]);
  }
  DIP_Field(const CIDR &c): CIDR_Field(c) {
    _bdd = toBDD(sbm["dip"]);
  }

  DIP_Field(const DIP_Field & d) {
    addr = d.addr;
    mask = d.mask;
    _bdd = toBDD(sbm["dip"]);
  }
  list<DIP_Field> zoom_in(int nlevel);

};




class Port_Field: public Field, public Interval 
{
public:
  static int zoom_min;
  static int zoom_max;
  Port_Field():Interval(0,0) {}
  ~Port_Field() {}
  Port_Field(int min, int max): 
    Interval(min, max) {}
  Port_Field(int sig): 
    Interval(sig) {}
  Port_Field(const char * s_min, const char * s_max): 
    Interval(s_min, s_max) {}
  Port_Field(std::string strn): Interval(strn) {}

  Port_Field(const Port_Field &p): Interval(p) {}


  bdd toBDD(bvec V);
  static std::map<std::string, int> PortMap;
  std::string toString() {return Interval::toString();}
  
  int current_zoom(){return 0;}
};

class SPT_Field: public Port_Field {
public:
  static std::string name;
  SPT_Field(const char *s_min, const char *s_max): 
    Port_Field(s_min, s_max)
  {
    _bdd = toBDD(sbm["spt"]);
  }

  SPT_Field(std::string strn): Port_Field(strn)   
  {
    _bdd = toBDD(sbm["spt"]);
  }

  SPT_Field(int val): Port_Field(val) 
  {
    _bdd = toBDD(sbm["spt"]);
  }
  
  SPT_Field(const Port_Field &f): Port_Field(f)
  {
    _bdd = toBDD(sbm["spt"]);
  }


};


class DPT_Field: public Port_Field {
public:
  static std::string name;
  DPT_Field(const char *s_min, const char *s_max): 
    Port_Field(s_min, s_max)
  {
    _bdd = toBDD(sbm["dpt"]);
  }
  DPT_Field(std::string strn): Port_Field(strn)   
  {
    _bdd = toBDD(sbm["dpt"]);
  }
  DPT_Field(int val): Port_Field(val) 
  {
    _bdd = toBDD(sbm["dpt"]);
  }
  DPT_Field(const Port_Field &f): Port_Field(f)
  {
    _bdd = toBDD(sbm["dpt"]);    
  }

};



class Proto_Field: public Val_Field{
public:
  static int zoom_min;
  static int zoom_max;
  static map<string, int> ProtoMap;

  static std::string name;
  Proto_Field() {
    nbits =8;
  }
  Proto_Field(int v) {
    _val=v;
    nbits=8;
    _bdd = toBDD(sbm["prt"]);
  }
  Proto_Field(const char * sVal){
    nbits =8;
    _val=atoi(sVal);
    _bdd = toBDD(sbm["prt"]);
  }
  int current_zoom(){return 0;}

	bool isICMP(){return (_val == 1);}
	bool isUDP(){return (_val == 17);}
	bool isTCP(){return (_val == 6);}
};

class ICMPType_Field: public Val_Field 
{
public:
  static std::string name;
  ICMPType_Field(int _ict) {
    nbits=8;
    _val = _ict;
    _bdd = toBDD(sbm["icmp_type"]);
  }
  

  int current_zoom(){return 0;}
  
};

class FlowDef
{
 public:
  map<string, int> defmap;
  
  FlowDef(){
    defmap.insert(make_pair("prt", 8));
    defmap.insert(make_pair("sip", 32));
    defmap.insert(make_pair("spt", 16));
    defmap.insert(make_pair("dip", 32));
    defmap.insert(make_pair("dpt", 16));
  }

  FlowDef(int tuple){
    if (5==tuple){
      defmap.insert(make_pair("prt", 8));
      defmap.insert(make_pair("sip", 32));
      defmap.insert(make_pair("spt", 16));
      defmap.insert(make_pair("dip", 32));
      defmap.insert(make_pair("dpt", 16));

    }
    else if (2==tuple){
      defmap.insert(make_pair("prt", 0));
      defmap.insert(make_pair("sip", 32));
      defmap.insert(make_pair("spt", 0));
      defmap.insert(make_pair("dip", 32));
      defmap.insert(make_pair("dpt", 0));
    }
  }

  FlowDef(string type){
    if(type=="5 tuple"){
      defmap.insert(make_pair("prt", 8));
      defmap.insert(make_pair("sip", 32));
      defmap.insert(make_pair("spt", 16));
      defmap.insert(make_pair("dip", 32));
      defmap.insert(make_pair("dpt", 16));
    } else if(type=="2 tuple"){
      defmap.insert(make_pair("sip", 32));
      defmap.insert(make_pair("dip", 32));
    } else if(type =="sip"){
      defmap.insert(make_pair("sip", 32));
    } else if(type =="dip"){
      defmap.insert(make_pair("dip", 32));
    }

  }
};

typedef std::map<string, Field *, less<string> > PREDMAP;

class Predicate {
public:
  bdd  _bdd;
  //std::map<string, Field *> fields;
  PREDMAP fields;

  Predicate(): _bdd(bddtrue) {}

  Predicate(std::string strn);

  Predicate(std::string _proto, 
	    std::string _sip, 
	    std::string _spt, 
	    std::string _dip, 
	    std::string _dpt)
  {
    set_proto(_proto);
    set_sip(_sip);
    set_spt(_spt);
    set_dip(_dip);
    set_dpt(_dpt);
  }


  Predicate(std::string _proto, 
	    std::string _sip, 
	    std::string _dip)
  {
    //cout << _proto << _sip << _dip<< endl;
    set_proto(_proto);
    set_sip(_sip);
    set_spt("any");
    set_dip(_dip);
    set_dpt("any");

  }

  Predicate(std::vector<std::string> _vals) 
  {
    set_proto(_vals[0]);
    set_sip(_vals[1]);
    set_spt(_vals[2]);
    set_dip(_vals[3]);
    set_dpt(_vals[4]);
  }

  Predicate(const u_char * packet);
  Predicate(const Predicate & p);




  void set_proto(std::string proto);
  void set_proto(int  _proto);

  void set_sip(std::string sip);
  void set_sip(CIDR sip);
  void set_sip(CIDR *sip) {set_sip(*sip);}

  void set_spt(std::string spt);
  void set_spt(int spt);
  void set_spt(const Port_Field &_spt);
  //SPT_Field * get_spt();

  void set_icmptype(string _ict);
  void set_icmptype(int _ict);

  void set_dip(std::string dip);
  void set_dip(CIDR dip);
  void set_dip(CIDR *dip) {set_dip(*dip);}

  void set_dpt(std::string dpt);
  void set_dpt(int dpt);
  void set_dpt(const Port_Field &_dpt);

  ~Predicate() {
    fields.clear();
  }
  Field * getField(string _field);

	bool isICMP(){return ((Proto_Field *) getField("prt"))->isICMP();}
	bool isUDP(){return  ((Proto_Field *) getField("prt"))->isUDP();}
	bool isTCP(){return  ((Proto_Field *) getField("prt"))->isTCP();}
	bool isAnyProto(){return (getField("prt")==NULL);}


  string getFieldString(string _field);
  string toString();
  //string toString(string format);
  bdd toBDD();

  std::list<Predicate> split(string dimension, int num);

  bool isSingular();
  int current_zoom(string _dimension);

  bool isFlow(FlowDef def);


};

class CompositePredicate: public Predicate 
{
public: 
  bool invert;

  CompositePredicate (){}
  CompositePredicate (string s): Predicate(s.substr(2)){
    //cout << s.substr(2)<< endl;
    if (s[0]=='-'){
      invert = true;
    }
    else{
      invert = false;
    }
  }

  CompositePredicate (const CompositePredicate &c): Predicate((Predicate &)c), invert(c.invert) {
    //cout << "copy compositePredicate" <<endl;
    _bdd = toBDD();
  }

  bdd toBDD() {
    //cout << "CompositePredicate::toBDD()" << endl;
    bdd temp = ((Predicate *)this)->toBDD();
    if(invert){
      _bdd = bdd_not(temp);
    }
    //cout << "OK" << endl;
    return _bdd;
  }
  
  string toString(string format){
    if(invert){
      return  "- "+ ((Predicate*) this)->toString();
    }
    else{
      return  "+ "+ ((Predicate*) this)->toString();
    }
  }
};

#endif
