/* -*-	Mode:C++; c-basic-offset:2; tab-width:2; indent-tabs-mode:t -*- */
#include "Packet.h"
#include "Predicate.h"


Packet::Packet(const u_char * packet) 
{
  std::map<std::string, bvec> sbm  = Field::sbm;
  struct ip * ippkt;
  unsigned int hdr_len;
  struct udphdr * udppkt;
  struct tcphdr * tcppkt;
  struct icmp *icmppkt;

  //ippkt = (struct ip *) (packet+14);


  bdd sip=bddtrue;
  bdd dip=bddtrue;
  bdd spt=bddtrue;
  bdd dpt=bddtrue; 
  bdd prt=bddtrue;
  bdd icmptype = bddtrue;

  bvec sipV, dipV, sptV, dptV, prtV, icmptypeV;

  ippkt = (struct ip *) (packet);

  
  sipV = bvec_con(32, ntohl(ippkt->ip_src.s_addr));

  //cout<< "src="<< inet_ntoa(ippkt->ip_src)<< endl;
  
  sip = bvec_equ(sipV, sbm["sip"]);

  dipV = bvec_con(32, ntohl(ippkt->ip_dst.s_addr));

  //cout<< "dst="<< inet_ntoa(ippkt->ip_dst)<< endl;

  dip = bvec_equ(dipV, sbm["dip"]);

  hdr_len = (ippkt->ip_hl) << 2 ;

  prtV = bvec_con(8, ippkt->ip_p);
  prt = bvec_equ(prtV, sbm["prt"]);

  switch((int)ippkt->ip_p){
  case 6:
    //cout << "tcp" << endl;
    tcppkt = (struct tcphdr *) (packet+hdr_len);
    sptV = bvec_con(16, ntohs(tcppkt->source));
    dptV = bvec_con(16, ntohs(tcppkt->dest));
    spt = bvec_equ(sptV, sbm["spt"]);
    dpt = bvec_equ(dptV, sbm["dpt"]);
    _bdd = sip & dip & spt & dpt & prt;

//     set_spt(tcppkt->source);
//     set_dpt(tcppkt->dest);
    break;
  case 17:
    //cout << "udp" << endl;
    udppkt = (struct udphdr *) (packet+ hdr_len); 
    sptV = bvec_con(16, ntohs(udppkt->source));
    dptV = bvec_con(16, ntohs(udppkt->dest));
    spt = bvec_equ(sptV, sbm["spt"]);
    dpt = bvec_equ(dptV, sbm["dpt"]);
    _bdd = sip & dip & spt & dpt & prt;
    break;
  case 1:
    //cout << "icmp"<< endl;
    icmppkt = (struct icmp *) (packet+hdr_len);
    icmptypeV = bvec_con(8, icmppkt->icmp_type);
    icmptype = bvec_equ(icmptypeV, sbm["icmp_type"]);

    _bdd = sip & dip & prt & icmptype; 

//     set_icmptype(icmppkt->icmp_type);
    break;
  default:
    cout << "unknow protocol " << (int) ippkt->ip_p << endl;
    exit(-1);
    break;
  }

}
