/* -*-	Mode:C++; c-basic-offset:2; tab-width:2; indent-tabs-mode:t -*- */
#ifndef __CPP_Interval_H_
#define __CPP_Interval_H_ 1

#include <list>
#include <string>

using namespace std;
/**
 * An interval is [l, r], both inclusive
 **/
class Interval 
{
public:
  int left;
  int right;


 

  Interval(std::string);
  Interval(int min, int max): left(min),right(max) 
  {}

  Interval(int sig): left(sig),right(sig) 
  {}
    
  Interval(const char *s_min, const char *s_max)
  {
    left = atoi(s_min);
    right = atoi(s_max);
  }

  Interval(const Interval &c){
    left = c.left;
    right = c.right;
  }

  std::string toString();

  std::list<Interval> split(int size);

  int len(){
    return (right-left+1);
  }
};

#endif
