/* -*-	Mode:C++; c-basic-offset:2; tab-width:2; indent-tabs-mode:t -*- */
#include <iostream>
#include "Interval.h"
using namespace std;


Interval::Interval(std::string strn)
{
  string::size_type idx = strn.find('-');
  if(idx==string::npos){
    left = atoi(strn.c_str());
    right = left;
  }
  else{
    left = atoi(strn.substr(0, idx).c_str());
    right = atoi(strn.substr(idx+1).c_str());
    if (left >right){
      std::swap(left, right);
    }
  }
}

std::string Interval::toString()
{
  char temp[100];
  if (left ==right){
    snprintf(temp, 100, "%d", left);
  }
  else{
    snprintf(temp, 100, "%d-%d", left, right); 
  }
  return std::string(temp);
}



std::list<Interval> Interval::split(int size)
{
  list<Interval> res;

  int l=left;
  int r;
  if(left==right)
    res.push_back(Interval(left, right));

  r = min(l+size, right);
  //cout << l << " | "<< r << endl;
  for (l = left;r<right;){
    r = min(l+size-1, right);
    res.push_back(Interval(l, r));
    l = r+1;
  }
  return res;
}


// int main()
// {
//   Interval s = Interval(0, 0);

//   cout << s.toString() << endl;
//   list<Interval> res = s.split(100);

//   list<Interval>::iterator it;
//   for(it=res.begin();it!=res.end();++it){
//     cout << it->toString() << endl;
//   }
// }
