/* -*-	Mode:C++; c-basic-offset:2; tab-width:2; indent-tabs-mode:t -*- */
#ifndef __FIREMAN_CIDR_H
#define __FIREMAN_CIDR_H 1


#include <stdlib.h>
#include <string>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <assert.h>
#include <iostream>
#include <list>


class CIDR{
public:
  struct in_addr addr;
  struct in_addr mask;
  char strn[19];
  CIDR() {}
  ~CIDR() {}
  CIDR(const char * strn);
  CIDR(const char * str_addr, const char * str_mask, bool isMask=true);
  CIDR(const char * str_addr, int mask_len);
  CIDR(const CIDR &c) {  //copy constructor  
    //std::cout << "copy CIDR" << std::endl;
    addr = c.addr;
    mask = c.mask;
  }
  CIDR(struct in_addr _addr, struct in_addr _mask, bool isMask=true) {
    if(isMask){
      addr = _addr; 
      mask = _mask;
    }
    else{
      addr = _addr; 
      mask.s_addr = ~(_mask.s_addr);
    }
  }




  CIDR(struct in_addr _addr) {
    addr = _addr; 
    mask.s_addr = 0xffffffff;
  }

  std::string toString();

  int masklen() {return bitcount(mask.s_addr);}
  
  /* K&R page 50 */
  inline unsigned bitcount(unsigned int x) {
    int b=0;
    for (b=0;x!=0; x >>=1) {
      if (x &01){
	b++;
      }
    }
    return b;
  }

  struct in_addr net(){
    struct in_addr naddr;
    naddr.s_addr = (addr.s_addr & mask.s_addr);
    return naddr;
  }

  struct in_addr broadcast() {
    struct in_addr baddr;
    baddr.s_addr = (addr.s_addr & mask.s_addr) + (~(mask.s_addr));
    return baddr;
  }

  bool isANY(){
    return (mask.s_addr ==0);
  }

  std::list<CIDR> subnets(int masklen);
  CIDR supernet(int masklen);

};

//typedef CIDR CIDR;
#endif
