/* -*-	Mode:C++; c-basic-offset:2; tab-width:2; indent-tabs-mode:t -*- */
#include <iostream>

#include "ACL.h"
#include "bdd.h"

string ACL::toString()
{
  list<Rule>::iterator it;
  string s;
  //string s = name+"\n"+"------------------\n";
  for (it=rules.begin();it !=rules.end();++it){
    s += it->toString();
    s += "\n";
  }
  return s;
}


string ACL::toString(int count)
{
  list<Rule>::iterator it;
  string s;
  //string s = name+"\n"+"------------------\n";

  char temp[10];
  for (it=rules.begin();it !=rules.end();++it){
    snprintf(temp, 10, "%d", count);
    s += string(temp)+ " "+ it->toString() + "\n";
    ++ count; 
  }
  return s;
}

string ACL::toString(string fmt)
{
  cout << fmt << endl;
  if (fmt=="simple"){
    list<Rule>::iterator it;
    string s ="";
    string temp, res;
    
    int i = 0;
    for (it=rules.begin();it !=rules.end();++it){
      temp =  it->pred.getFieldString("prt");
      if (temp == "1"){
				continue;
      }
      else{
				res = it->target + " " + temp + " ";
				res += it->pred.getFieldString("sip")+" ";
				res += it->pred.getFieldString("spt")+" ";
				res += it->pred.getFieldString("dip")+" ";
				res += it->pred.getFieldString("dpt");
      }
      
      cout << i << " " + res << endl;
      //s+= string(i)+" " + res + " \n";
      ++i;
    }
    return "ok";
    //return s;
  }
  else{
    return "Error";
  }

}


void ACL::setPolicy(bool accept)
{
  Predicate a = Predicate("any any any any any");

  if(accept){
    push_back(Rule("accept", a));
  }
  else{
    push_back(Rule("deny", a));
  }
  //delete a;
}


/**
 *  If chain A calls chain B, A depends on B, 
 *  Assume the call graph is a DAG, which is also enforced by IPTables 
 **/
set<string> ACL::dependency()
{
	list<Rule>::iterator pos;
	//set<string> res;
	
	for (pos = rules.begin(); pos != rules.end(); ++pos){
		if (! pos->terminal()){
			cout << name <<" -> " << pos->target << endl;
			deps.insert(pos->target);
		}
	}	
	return deps;
}


