# define Y_EOF 0
# define Y_NL 258
# define Y_INT 259
# define Y_ID 260
# define Y_REG 261
# define Y_FP_REG 262
# define Y_STR 263
# define Y_FP 264
# define Y_ABS_D_OP 265
# define Y_ABS_S_OP 266
# define Y_ADDIU_OP 267
# define Y_ADDI_OP 268
# define Y_ADDU_OP 269
# define Y_ADD_D_OP 270
# define Y_ADD_OP 271
# define Y_ADD_S_OP 272
# define Y_ANDI_OP 273
# define Y_AND_OP 274
# define Y_BC0F_OP 275
# define Y_BC0T_OP 276
# define Y_BC1F_OP 277
# define Y_BC1T_OP 278
# define Y_BC2F_OP 279
# define Y_BC2T_OP 280
# define Y_BC3F_OP 281
# define Y_BC3T_OP 282
# define Y_BEQ_OP 283
# define Y_BGEZAL_OP 284
# define Y_BGEZ_OP 285
# define Y_BGTZ_OP 286
# define Y_BLEZ_OP 287
# define Y_BLTZAL_OP 288
# define Y_BLTZ_OP 289
# define Y_BNE_OP 290
# define Y_BREAK_OP 291
# define Y_CALL_POP 292
# define Y_CFC0_OP 293
# define Y_CFC1_OP 294
# define Y_CFC2_OP 295
# define Y_CFC3_OP 296
# define Y_COP0_OP 297
# define Y_COP1_OP 298
# define Y_COP2_OP 299
# define Y_COP3_OP 300
# define Y_CTC0_OP 301
# define Y_CTC1_OP 302
# define Y_CTC2_OP 303
# define Y_CTC3_OP 304
# define Y_CVT_POP 305
# define Y_CVT_D_S_OP 306
# define Y_CVT_D_W_OP 307
# define Y_CVT_S_D_OP 308
# define Y_CVT_S_W_OP 309
# define Y_CVT_W_D_OP 310
# define Y_CVT_W_S_OP 311
# define Y_C_EQ_D_OP 312
# define Y_C_EQ_S_OP 313
# define Y_C_F_D_OP 314
# define Y_C_F_S_OP 315
# define Y_C_LE_D_OP 316
# define Y_C_LE_S_OP 317
# define Y_C_LT_D_OP 318
# define Y_C_LT_S_OP 319
# define Y_C_NGE_D_OP 320
# define Y_C_NGE_S_OP 321
# define Y_C_NGLE_D_OP 322
# define Y_C_NGLE_S_OP 323
# define Y_C_NGL_D_OP 324
# define Y_C_NGL_S_OP 325
# define Y_C_NGT_D_OP 326
# define Y_C_NGT_S_OP 327
# define Y_C_OLE_D_OP 328
# define Y_C_OLE_S_OP 329
# define Y_C_SEQ_D_OP 330
# define Y_C_SEQ_S_OP 331
# define Y_C_SF_D_OP 332
# define Y_C_SF_S_OP 333
# define Y_C_UEQ_D_OP 334
# define Y_C_UEQ_S_OP 335
# define Y_C_ULE_D_OP 336
# define Y_C_ULE_S_OP 337
# define Y_C_UN_D_OP 338
# define Y_C_UN_S_OP 339
# define Y_DIVU_OP 340
# define Y_DIV_D_OP 341
# define Y_DIV_OP 342
# define Y_DIV_S_OP 343
# define Y_DONE_POP 344
# define Y_GET_POP 345
# define Y_GETC_POP 346
# define Y_GETI_POP 347
# define Y_GIFEQ_POP 348
# define Y_GIFNE_POP 349
# define Y_GIFGT_POP 350
# define Y_GIFGE_POP 351
# define Y_GIFLT_POP 352
# define Y_GIFLE_POP 353
# define Y_GOTO_POP 354
# define Y_JALR_OP 355
# define Y_JAL_OP 356
# define Y_JR_OP 357
# define Y_J_OP 358
# define Y_LBU_OP 359
# define Y_LB_OP 360
# define Y_LHU_OP 361
# define Y_LH_OP 362
# define Y_LUI_OP 363
# define Y_LWC0_OP 364
# define Y_LWC1_OP 365
# define Y_LWC2_OP 366
# define Y_LWC3_OP 367
# define Y_LWL_OP 368
# define Y_LWR_OP 369
# define Y_LW_OP 370
# define Y_MFC0_OP 371
# define Y_MFC1_OP 372
# define Y_MFC2_OP 373
# define Y_MFC3_OP 374
# define Y_MFHI_OP 375
# define Y_MFLO_OP 376
# define Y_MOV_D_OP 377
# define Y_MOV_S_OP 378
# define Y_MTC0_OP 379
# define Y_MTC1_OP 380
# define Y_MTC2_OP 381
# define Y_MTC3_OP 382
# define Y_MTHI_OP 383
# define Y_MTLO_OP 384
# define Y_MULTU_OP 385
# define Y_MULT_OP 386
# define Y_MUL_D_OP 387
# define Y_MUL_S_OP 388
# define Y_NEG_D_OP 389
# define Y_NEG_S_OP 390
# define Y_NOR_OP 391
# define Y_ORI_OP 392
# define Y_OR_OP 393
# define Y_RFE_OP 394
# define Y_SB_OP 395
# define Y_SH_OP 396
# define Y_SLLV_OP 397
# define Y_SLL_OP 398
# define Y_SLTIU_OP 399
# define Y_SLTI_OP 400
# define Y_SLTU_OP 401
# define Y_SLT_OP 402
# define Y_SRAV_OP 403
# define Y_SRA_OP 404
# define Y_SRLV_OP 405
# define Y_SRL_OP 406
# define Y_SUBU_OP 407
# define Y_SUB_D_OP 408
# define Y_SUB_OP 409
# define Y_SUB_S_OP 410
# define Y_SWC0_OP 411
# define Y_SWC1_OP 412
# define Y_SWC2_OP 413
# define Y_SWC3_OP 414
# define Y_SWL_OP 415
# define Y_SWR_OP 416
# define Y_SW_OP 417
# define Y_SYSCALL_OP 418
# define Y_TLBP_OP 419
# define Y_TLBR_OP 420
# define Y_TLBWI_OP 421
# define Y_TLBWR_OP 422
# define Y_XORI_OP 423
# define Y_XOR_OP 424
# define Y_ABS_POP 425
# define Y_BAL_POP 426
# define Y_BEQZ_POP 427
# define Y_BGEU_POP 428
# define Y_BGE_POP 429
# define Y_BGTU_POP 430
# define Y_BGT_POP 431
# define Y_BLEU_POP 432
# define Y_BLE_POP 433
# define Y_BLTU_POP 434
# define Y_BLT_POP 435
# define Y_BNEZ_POP 436
# define Y_B_POP 437
# define Y_LA_POP 438
# define Y_LD_POP 439
# define Y_LP_POP 440
# define Y_LI_POP 441
# define Y_LI_D_POP 442
# define Y_LI_S_POP 443
# define Y_L_D_POP 444
# define Y_L_S_POP 445
# define Y_MFC1_D_POP 446
# define Y_MTC1_D_POP 447
# define Y_MOVE_POP 448
# define Y_MULOU_POP 449
# define Y_MULO_POP 450
# define Y_MUL_POP 451
# define Y_NEGU_POP 452
# define Y_NEG_POP 453
# define Y_NOP_POP 454
# define Y_NOT_POP 455
# define Y_PUT_POP 456
# define Y_PUTC_POP 457
# define Y_PUTI_POP 458
# define Y_PUTS_POP 459
# define Y_REMU_POP 460
# define Y_RETURN_POP 461
# define Y_REM_POP 462
# define Y_ROL_POP 463
# define Y_ROR_POP 464
# define Y_SD_POP 465
# define Y_SEQ_POP 466
# define Y_SGEU_POP 467
# define Y_SGE_POP 468
# define Y_SGTU_POP 469
# define Y_SGT_POP 470
# define Y_SLEU_POP 471
# define Y_SLE_POP 472
# define Y_SNE_POP 473
# define Y_S_D_POP 474
# define Y_S_S_POP 475
# define Y_ULHU_POP 476
# define Y_ULH_POP 477
# define Y_ULW_POP 478
# define Y_USH_POP 479
# define Y_USW_POP 480
# define Y_ALIAS_DIR 481
# define Y_ALIGN_DIR 482
# define Y_ASCII_DIR 483
# define Y_ASCIIZ_DIR 484
# define Y_ASM0_DIR 485
# define Y_BGNB_DIR 486
# define Y_BYTE_DIR 487
# define Y_COMM_DIR 488
# define Y_DATA_DIR 489
# define Y_DOUBLE_DIR 490
# define Y_ENDB_DIR 491
# define Y_ENDR_DIR 492
# define Y_END_DIR 493
# define Y_ENT_DIR 494
# define Y_EQ_DIR 495
# define Y_ERR_DIR 496
# define Y_EXTERN_DIR 497
# define Y_FILE_DIR 498
# define Y_FLOAT_DIR 499
# define Y_FMASK_DIR 500
# define Y_FRAME_DIR 501
# define Y_GLOBAL_DIR 502
# define Y_HALF_DIR 503
# define Y_K_TEXT_DIR 504
# define Y_K_DATA_DIR 505
# define Y_LABEL_DIR 506
# define Y_LCOMM_DIR 507
# define Y_LIVEREG_DIR 508
# define Y_LOC_DIR 509
# define Y_MASK_DIR 510
# define Y_NOALIAS_DIR 511
# define Y_OPTIONS_DIR 512
# define Y_RDATA_DIR 513
# define Y_REPEAT_DIR 514
# define Y_SDATA_DIR 515
# define Y_SET_DIR 516
# define Y_SPACE_DIR 517
# define Y_STRUCT_DIR 518
# define Y_TEXT_DIR 519
# define Y_VERSTAMP_DIR 520
# define Y_VREG_DIR 521
# define Y_WORD_DIR 522

# line 311 "parser.y"
#include <stdio.h>
#include "endian.h"
#include "spim.h"
#include "inst.h"
#include "data.h"
#include "mem.h"
#include "reg.h"
#include "sym_tbl.h"

typedef struct ll
{
  label *head;
  struct ll *tail;
} label_list;


/* NOTE: defines for *_RMUM should not be changes lightly. */
/* These must match with the registers used by SYSCALL and */
/* The destination must match src2 so that move works. -SK */
#define A_SRC1_RNUM	4
#define A_SRC2_RNUM	2
#define A_DEST_RNUM	2
#define A_SUB_RNUM	3
#define A_DSUB_RNUM	5
#define AF_SRC1_RNUM	12
#define AF_SRC2_RNUM	0
#define AF_DEST_RNUM	0


/* Local functions: */

static void clear_labels();
static label_list * cons_label (label *head, label_list *tail);

static void div_inst (int, int, int, int, int);
static void mult_inst (int, int, int, int);
static void nop_inst (void);
static void set_eq_inst (int, int, int, int);
static void set_ge_inst (int, int, int, int);
static void set_gt_inst (int, int, int, int);
static void set_le_inst (int, int, int, int);
static void store_word_data (int);
static void trap_inst (void);
int op_to_float_op(int);
int op_to_double_op(int);
int BadTypes(int, int, int);


char *input_file_name;

extern int y_str_length;

static int null_term;		/* Non-zero means string terminate by \0 */

static void (*store_op) ();	/* Function to store items in an EXPR_LST */

int data_dir = 0;		/* Non-zero means item in data segment */

int text_dir = 1;		/* Non-zero means item in text segment */

static label_list *this_line_labels = NULL; /* List of label for curent line */

extern int in_kernel;		/* Non-zero means kernel segment */

static label *abstract_line_label;	/* Label for curent line or NULL */

static int noat_flag = 0;	/* Non-zero means program can use $1 */


# line 384 "parser.y"
typedef union  {
    int ival;
    char *cptr;
    addr_expr *aeptr;
    imm_expr *ieptr;
    double *dptr;
} YYSTYPE;
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 2591 "parser.y"

/* Maintain and update the address of labels for the current line. */

void
fix_current_label_address (mem_addr new_addr)
{
  label_list *l;

  for (l = this_line_labels; l != NULL; l = l->tail)
    l->head->addr = new_addr;
  clear_labels ();
}


static label_list * cons_label (label *head, label_list *tail)
{
  label_list *c = (label_list *) malloc (sizeof (label_list));

  c->head = head;
  c->tail = tail;
  return (c);
}


static void
clear_labels ()
{
  label_list *n;

  for ( ; this_line_labels != NULL; this_line_labels = n)
    {
      n = this_line_labels->tail;
      free (this_line_labels);
    }
}


int op_to_imm_op (int opcode)
{
  switch (opcode)
    {
    case Y_ADD_OP: return (Y_ADDI_OP);
    case Y_ADDU_OP: return (Y_ADDIU_OP);
    case Y_AND_OP: return (Y_ANDI_OP);
    case Y_OR_OP: return (Y_ORI_OP);
    case Y_XOR_OP: return (Y_XORI_OP);
    case Y_SLT_OP: return (Y_SLTI_OP);
    case Y_SLTU_OP: return (Y_SLTIU_OP);
    case Y_SLLV_OP: return (Y_SLL_OP);
    case Y_SRAV_OP: return (Y_SRA_OP);
    case Y_SRLV_OP: return (Y_SRL_OP);
    default: fatal_error ("Can't convert op to immediate op\n");
      /*NOTREACHED*/
    }
}


int imm_op_to_op (int opcode)
{
  switch (opcode)
    {
    case Y_ADDI_OP: return (Y_ADD_OP);
    case Y_ADDIU_OP: return (Y_ADDU_OP);
    case Y_ANDI_OP: return (Y_AND_OP);
    case Y_ORI_OP: return (Y_OR_OP);
    case Y_XORI_OP: return (Y_XOR_OP);
    case Y_SLTI_OP: return (Y_SLT_OP);
    case Y_SLTIU_OP: return (Y_SLTU_OP);
    case Y_J_OP: return (Y_JR_OP);
    case Y_LUI_OP: return (Y_ADDU_OP);
    case Y_SLL_OP: return (Y_SLLV_OP);
    case Y_SRA_OP: return (Y_SRAV_OP);
    case Y_SRL_OP: return (Y_SRLV_OP);
    default: fatal_error ("Can't convert immediate op to op");
      /*NOTREACHED*/
    }
}

int op_to_float_op(int opcode)
{
  switch (opcode)
    {
    case Y_ADD_OP: return Y_ADD_S_OP;
    case Y_SUB_OP: return Y_SUB_S_OP;
    case Y_MULT_OP: return Y_MUL_S_OP;
    case Y_MUL_POP: return Y_MUL_S_OP;
    case Y_DIV_OP: return Y_DIV_S_OP;
    default: yyerror ("No such floating point operation");
	return Y_ADD_D_OP;
    }
}


int op_to_double_op(int opcode)
{
  switch (opcode)
    {
    case Y_ADD_OP: return Y_ADD_D_OP;
    case Y_SUB_OP: return Y_SUB_D_OP;
    case Y_MULT_OP: return Y_MUL_D_OP;
    case Y_DIV_OP: return Y_DIV_D_OP;
    default: yyerror ("No such floating point operation");
	return Y_ADD_D_OP;
    }
}


static void nop_inst (void)
{
  r_type_inst (Y_OR_OP, 0, 0, 0);
}


static void trap_inst (void)
{
  r_type_inst (Y_BREAK_OP, 0, 0, 0);
}


imm_expr *branch_offset (int n_inst)
{
  return (const_imm_expr ((n_inst << 2) - 4));/* Later shifted right 2 places */
}


static void div_inst (int op, int rd, int rs, int rt, int const_divisor)
{
  if (rd != 0 && !const_divisor)
    {
      i_type_inst (Y_BNE_OP, 0, rt, branch_offset (2));
      trap_inst ();
    }
  if (op == Y_DIV_OP || op == Y_REM_POP)
    r_type_inst (Y_DIV_OP, 0, rs, rt);
  else
    r_type_inst (Y_DIVU_OP, 0, rs, rt);
  if (rd != 0)
    {
      if (op == Y_DIV_OP || op == Y_DIVU_OP)
	r_type_inst (Y_MFLO_OP, rd, 0, 0);
      else
	r_type_inst (Y_MFHI_OP, rd, 0, 0);
    }
}


static void mult_inst (int op, int rd, int rs, int rt)
{
  if (op == Y_MULOU_POP)
    r_type_inst (Y_MULTU_OP, 0, rs, rt);
  else
    r_type_inst (Y_MULT_OP, 0, rs, rt);
  if (op == Y_MULOU_POP && rd != 0)
    {
      r_type_inst (Y_MFHI_OP, 1, 0, 0);	/* Use $at */
      i_type_inst (Y_BEQ_OP, 0, 1, branch_offset (2));
      trap_inst ();
    }
  else if (op == Y_MULO_POP && rd != 0)
    {
      r_type_inst (Y_MFHI_OP, 1, 0, 0); /* use $at */
      r_type_inst (Y_MFLO_OP, rd, 0, 0);
      r_sh_type_inst (Y_SRA_OP, rd, rd, 31);
      i_type_inst (Y_BEQ_OP, rd, 1, branch_offset (2));
      trap_inst ();
    }
  if (rd != 0)
    r_type_inst (Y_MFLO_OP, rd, 0, 0);
}


static void set_le_inst (int op, int rd, int rs, int rt)
{
  i_type_inst (Y_BNE_OP, rs, rt, branch_offset (3));
  i_type_inst (Y_ORI_OP, rd, 0, const_imm_expr (1));
  i_type_inst (Y_BEQ_OP, 0, 0, branch_offset (2));
  r_type_inst ((op == Y_SLE_POP ? Y_SLT_OP : Y_SLTU_OP), rd, rs, rt);
}


static void set_gt_inst (int op, int rd, int rs, int rt)
{
  r_type_inst (op == Y_SGT_POP ? Y_SLT_OP : Y_SLTU_OP, rd, rt, rs);
}


static void set_ge_inst (int op, int rd, int rs, int rt)
{
  i_type_inst (Y_BNE_OP, rs, rt, branch_offset (3));
  i_type_inst (Y_ORI_OP, rd, 0, const_imm_expr (1));
  i_type_inst (Y_BEQ_OP, 0, 0, branch_offset (2));
  r_type_inst (op == Y_SGE_POP ? Y_SLT_OP : Y_SLTU_OP, rd, rt, rs);
}


static void set_eq_inst (int op, int rd, int rs, int rt)
{
  imm_expr *if_eq, *if_neq;

  if (op == Y_SEQ_POP)
    if_eq = const_imm_expr (1), if_neq = const_imm_expr (0);
  else
    if_eq = const_imm_expr (0), if_neq = const_imm_expr (1);

  i_type_inst (Y_BEQ_OP, rs, rt, branch_offset (3));
  /* RD <- 0 (if not equal) */
  i_type_inst (Y_ORI_OP, rd, 0, if_neq);
  i_type_inst (Y_BEQ_OP, 0, 0, branch_offset (2)); /* Branch always */
  /* RD <- 1 */
  i_type_inst (Y_ORI_OP, rd, 0, if_eq);
}


/* Store the value either as a datum or instruction. */

static void store_word_data (int value)
{
  if (data_dir)
    store_word (value);
  else if (text_dir)
    store_instruction (inst_decode (value));
}

int BadTypes(int t1, int t2, int t3)
{
    return (((t2 != t3) || (t1 != t2))
	&& (((t1 != WORD_A_TYPE) && (t1 != BYTE_A_TYPE))
	||  ((t2 != WORD_A_TYPE) && (t2 != BYTE_A_TYPE))
	||  ((t3 != WORD_A_TYPE) && (t3 != BYTE_A_TYPE))
	));
}

/* Old version that allows arrays from all vars */
#ifdef OLDVER
void Store(char *xlabel, int reg)
{
  switch (get_label_type((char *) xlabel)) {
    case WORD_A_TYPE:
      if (reg != 0)
	  r_sh_type_inst (Y_SLL_OP, reg, reg, 2);
      i_type_inst (Y_SW_OP, A_DEST_RNUM, reg,
	addr_expr_imm(make_addr_expr(0, xlabel, 0)));
      break;
    case BYTE_A_TYPE:
      i_type_inst (Y_SB_OP, A_DEST_RNUM, reg,
	addr_expr_imm(make_addr_expr(0, xlabel, 0)));
      break;
    case FLOAT_A_TYPE:
      if (reg != 0)
	  r_sh_type_inst (Y_SLL_OP, reg, reg, 2);
      i_type_inst (Y_SWC1_OP, AF_DEST_RNUM, reg,
	addr_expr_imm(make_addr_expr(0, xlabel, 0)));
      break;
    case DOUBLE_A_TYPE:
      if (reg != 0)
	  r_sh_type_inst (Y_SLL_OP, reg, reg, 3);
      i_type_inst (Y_SWC1_OP, AF_DEST_RNUM, reg,
	addr_expr_imm(make_addr_expr(0, xlabel, 0)));
      i_type_inst (Y_SWC1_OP, AF_DEST_RNUM + 1, reg,
	incr_expr_offset(addr_expr_imm(make_addr_expr(0, xlabel, 0)), 4));
      break;
    default:
      yyerror ("Unknown type");
  }
}
#else /* OLDVER */
void Store(char *xlabel, int reg)
{
  if (reg == 0) {
    switch (get_label_type((char *) xlabel)) {
      case WORD_A_TYPE:
	i_type_inst (Y_SW_OP, A_DEST_RNUM, reg,
	  addr_expr_imm(make_addr_expr(0, xlabel, 0)));
	break;
      case BYTE_A_TYPE:
	i_type_inst (Y_SB_OP, A_DEST_RNUM, reg,
	  addr_expr_imm(make_addr_expr(0, xlabel, 0)));
	break;
      case FLOAT_A_TYPE:
	i_type_inst (Y_SWC1_OP, AF_DEST_RNUM, reg,
	  addr_expr_imm(make_addr_expr(0, xlabel, 0)));
	break;
      case DOUBLE_A_TYPE:
	i_type_inst (Y_SWC1_OP, AF_DEST_RNUM, reg,
	  addr_expr_imm(make_addr_expr(0, xlabel, 0)));
	i_type_inst (Y_SWC1_OP, AF_DEST_RNUM + 1, reg,
	  incr_expr_offset(addr_expr_imm(make_addr_expr(0, xlabel, 0)), 4));
	break;
      default:
	yyerror ("Unknown type");
    }
  }
  else if (0 == strcmp(xlabel, "M")) {
    /* reg = reg x 4
    if (reg != 0)
	r_sh_type_inst (Y_SLL_OP, reg, reg, 2);
    */
    i_type_inst (Y_SW_OP, A_DEST_RNUM, reg,
      addr_expr_imm(make_addr_expr(0, NULL, 0)));
  }
  else if (0 == strcmp(xlabel, "m")) {
    i_type_inst (Y_SB_OP, A_DEST_RNUM, reg,
      addr_expr_imm(make_addr_expr(0, NULL, 0)));
  } else {
      yyerror("Bad array, use M or m.\n");
  }
}
#endif /* OLDVER */



void yyerror (const char *s)
{
  extern int line_no;
  extern char *input_file_name;

  sprintf(mess_buff, "spim: (parser) %s on line %d of file %s\n",
	 s, line_no, input_file_name);
  error (mess_buff);
  print_erroneous_line ();
}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 377,
	261, 383,
	-2, 381,
	};
# define YYNPROD 414
# define YYLAST 1195
short yyact[]={

   9, 358, 361, 396, 641, 359, 360, 542, 552, 459,
 358, 361, 394, 503, 359, 360, 358, 361, 298, 458,
 359, 360, 510, 513, 358, 361, 511, 512, 359, 360,
 638, 544, 409, 556, 321, 406, 408, 550, 543, 407,
 447, 452, 298, 443, 451, 616, 618, 447, 452, 617,
 298, 451, 578, 580, 311, 565, 579, 300, 301, 355,
 310, 305, 403, 354, 298, 590, 587, 298, 298, 478,
 541, 298, 305, 401, 397, 398, 305, 298, 355, 433,
 404, 646, 354, 581, 577, 436, 434, 429, 428, 426,
 421, 420, 419, 417, 414, 305,   4, 666, 447, 643,
 567, 566, 389, 564, 563, 562, 559, 546, 558, 555,
 548, 553, 439, 432, 431, 430, 424, 422, 418, 412,
 323, 295, 294, 293, 665, 664, 663, 654, 653, 652,
 504, 455, 304, 308, 380, 640, 292, 572, 670, 575,
 573, 576, 574, 532, 674, 570, 669, 306, 571, 673,
 668, 312, 667, 644, 315, 637, 509, 391, 316, 551,
 547, 441, 427, 423, 415, 413, 329, 331, 333, 411,
 336, 338, 340, 342, 410, 346, 348,   7,   6,   5,
   3,   2, 319, 320, 376,  46, 309,  67,  66,  65,
 405,  64,  63,  62,  61, 382, 383, 385, 386, 387,
 388, 390, 296,  60,  59,  58,  57, 399, 400, 402,
  56,  55, 322,  54,  53, 302, 303,  52, 307,  51,
 435, 313, 314,  49, 437, 438,  48,  41,  47,  45,
  44, 491, 324, 325, 326, 327, 328, 330, 332, 334,
 335, 337, 339, 341,  40, 345, 347, 349, 350, 351,
 352,  38,  37,  36, 322,  35,  34,  26,   8, 446,
  25,  22, 447, 445,  20, 247, 246, 162, 161, 152,
 249, 151, 248, 163, 153, 195, 191, 196, 192, 197,
 193, 198, 194, 207, 200, 199, 201, 202, 204, 203,
 208,  27, 353, 238, 239, 240, 241, 450, 449,  50,
  39, 242, 243, 244, 245,  68, 256, 257, 258, 259,
 260, 261, 280, 266, 278, 264, 290, 276, 288, 274,
 289, 275, 285, 271, 287, 273, 291, 277, 282, 268,
 286, 272, 284, 270, 281, 267, 283, 269, 279, 265,
 175, 251, 174, 250,  77,  74,  75,  76,  21, 374,
 378,  19,  12, 454,  11, 220, 218, 219, 217, 121,
 120, 123, 122, 131, 128, 134, 129, 130, 125, 126,
 124, 228, 229, 231, 232, 224, 225, 223, 222, 233,
 234, 236, 237, 226, 227, 182, 181, 253, 252, 263,
 262, 171, 164, 155, 149, 137, 138, 158, 168, 167,
 166, 157, 156, 159, 169, 160, 170, 173, 255, 172,
 254, 143, 146, 144, 145, 140, 141, 139, 150, 545,
 530, 531,  10, 165, 154,  29, 221, 205, 212, 211,
 210, 209, 216, 215, 214, 213, 206,  69,  13, 127,
  14,  15,  16,  17, 136, 135, 230, 235,  33, 180,
 179, 178,  31,  30,  28,  32,  70,  71,  72,  73,
 177, 557, 176,  43,  42, 142, 189, 188, 187, 186,
 185, 184, 183, 190, 148, 147, 133, 132,  18,  24,
  23,  78,  79,  80,  81,  82,  83,  84,  85,  86,
  88,  90,  91,  89,  92,  94,  95,  93,  96,  97,
  98,  99, 100, 101, 116,  87, 102, 103, 104, 105,
 106, 107, 108, 110, 109, 111, 112, 113, 114, 115,
 117, 118, 119, 344, 516, 549, 519, 622, 522, 299,
 525, 554, 534, 535, 297, 560, 297, 297, 442, 297,
 561, 416, 297, 297,   1, 317,   0, 317, 317, 568,
   0,   0, 318, 297, 297, 297, 297, 297, 297, 297,
 297, 297, 297, 297, 297,   0, 297, 297, 297, 297,
 297, 297, 322, 322, 533, 533, 533,   0,   0,   0,
 377,   0,   0, 381, 381, 381,   0,   0, 379,   0,
   0,   0, 384,   0, 444,   0, 507, 444, 514,   0,
 517, 444, 520,   0, 523,   0, 457,   0,   0,   0,
   0, 444, 444, 444, 444,   0, 444, 444, 444, 444,
   0,   0,   0, 425,   0,   0, 357,   0,   0, 475,
 582,   0,   0, 481,   0,   0, 485,   0,   0,   0,
   0,   0, 440,   0,   0,   0,   0,   0,   0, 501,
 502,   0,   0,   0,   0, 505, 506,   0, 639,   0,
 456,   0,   0, 508,   0, 515,   0, 518,   0, 521,
   0, 524,   0,   0,   0, 635,   0, 363, 365, 367,
 369, 371, 373, 473,   0, 476,   0, 479,   0,   0,
 483,   0, 486, 636, 488,   0, 490, 392, 393, 395,
 494,   0, 496,   0,   0,   0, 583,   0,   0, 586,
   0,   0,   0,   0, 591, 343, 593,   0, 533, 596,
   0, 599,   0,   0,   0, 602,   0, 605,   0, 608,
 610, 612, 614,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 655,   0, 536, 656,   0,   0,   0, 657,
   0,   0, 658, 538, 539, 659, 540,   0, 660,   0,
   0, 661,   0,   0, 662, 356, 362, 364, 366, 368,
 370, 372, 375, 584,   0,   0,   0,   0,   0, 589,
   0,   0,   0, 594,   0,   0, 597,   0, 600,   0,
   0,   0, 603,   0, 606,   0, 609, 611, 613, 615,
 619, 620, 621,   0,   0,   0,   0, 623, 624, 625,
 626, 627, 628, 629, 630, 631, 632, 633, 634,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 448,   0,
   0,   0, 453,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 460, 461, 462, 463,   0, 464, 465, 466,
 467,   0,   0,   0,   0,   0,   0, 492,   0,   0,
   0, 648, 649, 650, 651,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 492,   0,
 492,   0, 492,   0, 492,   0, 492,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 527,
   0,   0,   0, 528, 529,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 569,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 492,   0,
   0, 492,   0,   0,   0,   0, 492,   0, 492,   0,
   0, 492,   0, 492,   0,   0,   0, 492, 537, 492,
   0, 492, 492, 492, 492,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 468, 469, 470, 471, 472,   0, 474,   0, 477,   0,
 480, 482,   0, 484,   0, 487,   0, 489,   0,   0,
   0, 493,   0, 495,   0, 497, 498, 499, 500,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0, 642,   0,   0,   0,   0,   0,   0,
   0,   0, 526,   0, 645,   0, 647,   0,   0,   0,
   0,   0,   0, 585,   0,   0, 588,   0,   0,   0,
 592,   0,   0, 595,   0, 598,   0, 601,   0,   0,
   0, 604,   0, 607,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0, 671, 672 };
short yypact[]={

-1000,-1000,-164,   0,  78,-135,-136,-137,-1000,-1000,
-211,-204,-211,-184,-165,-211,-202,-202,-211,-211,
-202,-211,-204,-211,-211,-202,-1000,-139,-1000,-211,
-211,-211,-211,-184,-184,-184,-211,-184,-184,-184,
-184,-211,-184,-184,-211,-211,-211,-211,-178,-243,
-243,-243,-243,-243,-243,-243,-197,-178,-204,-211,
-211,-211,-204,-202,-202,-202,-202,-202,-165, 117,
-235,-249,-258,-186,-165,-188,-199,-1000,-181,-224,
-1000,-1000,-1000,-140,-1000,-166,-1000,-1000,-1000,-167,
-141,-1000,-168,-169,-170,-1000,-142,-1000,-143,-211,
-171,-1000,-172,-173,-144,-145,-146,-182,-174,-224,
-1000,-1000,-175,-224,-224,-1000,-1000,-147,-211,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,   3,-1000,-1000,   3,
-1000,-1000,-212,   3,  40,-1000,  40,-212,-245,-1000,
-1000,-1000,-255,   3,   3,   3,   3,-1000,   3,   3,
   3,   3,-1000,-1000,-211,-211,-211,-211,-211,  40,
-219,  40,-190,  40,-219,-211,  40,-219,  40,-211,
  40,-211,  40,-211,-1000,-211,  40,-211,  40,-211,
-211,-211,-211,-1000,-1000,-1000,-178,-178,-1000,-1000,
-1000,  39,-178,-178,-219,-237,-219,-237,-219,-237,
-219,-237,-219,-237,-1000,-1000,-211,-1000,-1000,-204,
-1000,-1000,-1000,-204,-204,-202,-202,-202,-202,-202,
  40,-235,-1000,-1000,-1000,-1000,-1000,-1000,-1000,  40,
  40,-1000,  40,-1000,-191,-1000,-1000,-1000,-1000,-1000,
-225,-225,-1000,-224,-224,-256,-1000,-1000,-1000,-148,
-224,-150,-230,-256,-151,-153,-1000,-224,-1000,-224,
-154,-155,-156,-206,-1000,-1000,-1000,-1000,-1000,-158,
-159,-224,-1000,-211, 105,  97,-1000,-1000,-1000,-1000,
-1000,-1000,  96,-1000,-176,-207,-177,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-237,-219,-1000,-235,-193,-1000,-235,
-212,-1000,-194,-235,-219,-1000,-235,-219,-235,-219,
-235,-1000,-1000,-219,-235,-219,-235,-219,-219,-219,
-219,-1000,-1000,-1000,-214,-1000,-1000,-178,-178,-178,
-1000,-1000,-1000,  39,-178,-178,-178,-178,-178,-178,
-178,-178,-178,-178,-178,-178,-1000,-1000,-1000,-1000,
-1000,-202,-1000,-1000,-1000,-1000,-237, 114,-1000,-1000,
-1000,-1000,-233,-1000,-1000,-233,-1000,-224,  77,-1000,
-1000,-260,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-211,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-160,-1000, 112,
-211,-179,-211,-161,-161,-161,-161,-1000,  36,  35,
  34,-1000,-1000,-1000,-1000,-237,-1000,-1000,-237,-1000,
-1000,-1000,-237,-1000,-1000,-237,-1000,-1000,-237,-1000,
-1000,-237,-1000,-1000,-237,-1000,-1000,-237,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,  33,  32,  31,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-162,-1000,-1000,-1000,-1000, 111,-1000, 109, 106,  98,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-211,
-211, 108, 103,-1000,-1000 };
short yypgo[]={

   0, 544, 132, 541, 422, 523, 158, 134, 715, 231,
 202, 297, 529, 354, 352, 353, 133, 351, 348, 186,
  34, 143, 300, 299, 626, 156, 264, 261, 260, 257,
 256, 255, 253, 252, 251, 244, 230, 229, 228, 227,
 226, 223, 219, 217, 214, 213, 211, 210, 206, 205,
 204, 203, 194, 193, 192, 191, 189, 188, 187, 110,
 185, 184,  13, 538, 298, 292, 181, 180, 179, 178,
 177, 174,   7, 169, 165, 107, 164,  37, 163, 162,
 161, 160, 159 };
short yyr1[]={

   0,  66,   1,  67,  67,  68,  68,  68,  68,  69,
  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
  69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
  69,  69,  69,   2,  24,  24,  24,  24,  25,  25,
  25,  25,  15,  15,  15,  15,  62,  62,  62,  62,
   4,   4,   4,   4,   4,   4,   4,   4,  13,  13,
  13,  14,  17,  17,  26,  26,  26,  18,  18,  18,
  18,  18,  18,  27,  27,  27,  28,  28,  28,  29,
  29,  30,  30,  30,  30,  30,  30,  30,  31,  31,
  31,  32,  32,  32,  32,  32,  32,  32,  33,  33,
  33,  34,  34,  34,  22,  22,  22,  22,  35,  35,
  35,  36,  36,  37,  37,  60,  60,  38,  38,  39,
  39,  40,  40,  40,  40,  40,  40,  40,  40,  41,
  41,  41,  41,  41,  41,  23,  23,  42,  42,  43,
  43,  44,  44,  45,  45,  46,  46,  47,  47,  47,
  47,  48,  48,  49,  49,  50,  50,  51,  51,  52,
  52,  52,  52,  52,  52,  52,  52,  52,  52,  53,
  53,  53,  53,  53,  53,  53,  53,  54,  54,  55,
  55,  55,  55,  55,  55,  55,  55,  56,  56,  56,
  56,  56,  56,  57,  57,  58,  58,  58,  58,  58,
  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,
  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,
  58,  58,  58,  70,  70,  71,  70,  73,  70,  70,
  70,  74,  70,  70,  70,  70,  76,  70,  70,  70,
  70,  70,  70,  70,  70,  70,  70,  78,  70,  70,
  70,  70,  79,  70,  70,  70,  70,  70,  70,  70,
  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,
  70,  80,  70,  63,  63,  63,  63,  63,  63,  63,
  63,  63,  63,  63,  64,  64,  64,  64,  64,  11,
  10,   8,   9,  61,   7,   6,   5,  16,  20,  21,
  19,  19,  12,  12,  65,  65,  72,  72,  72,  59,
  59,  59,  59,  75,  75,  81,  81,  81,  77,  77,
  82,  82,   3,   3 };
short yyr2[]={

   0,   0,   4,   2,   0,   2,   2,   1,   1,   3,
   3,   3,   3,   4,   4,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   1,   2,   1,   3,
   3,   3,   3,   3,   4,   4,   3,   4,   4,   3,
   4,   3,   4,   4,   4,   4,   3,   3,   4,   4,
   4,   4,   3,   4,   4,   4,   4,   4,   4,   4,
   4,   4,   4,   4,   4,   2,   3,   3,   4,   4,
   4,   4,   4,   4,   4,   4,   4,   4,   2,   2,
   3,   2,   3,   2,   2,   3,   3,   3,   4,   3,
   3,   3,   5,   5,   5,   5,   4,   4,   5,   5,
   4,   5,   5,   2,   2,   2,   2,   2,   2,   2,
   3,   3,   3,   2,   2,   1,   3,   3,   4,   4,
   4,   4,   4,   1,   1,   1,   1,   2,   1,   1,
   1,   2,   0,   3,   3,   3,   0,   3,   3,   3,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   3,   2,   0,   3,   0,   3,   1,
   2,   0,   3,   3,   1,   1,   0,   3,   2,   2,
   1,   2,   3,   3,   3,   1,   3,   0,   3,   3,
   4,   2,   0,   3,   2,   3,   3,   3,   3,   3,
   2,   2,   1,   1,   2,   2,   2,   1,   1,   3,
   4,   0,   3,   3,   1,   4,   1,   4,   3,   3,
   3,   6,   6,   1,   1,   1,   1,   3,   3,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   2,   1,   1,   1,
   1,   1,   1,   1,   0,   2,   1,   3,   1,   0,
   2,   1,   1,   0 };
short yychk[]={

-1000,  -1, -66, -67, 260, -68, -69, -70, 258,   0,
  -4, -13, -14, 438, 440, 441, 442, 443, 478, -17,
 -26, -18, -27, 480, 479, -28, -29, 291, 454, 425,
 453, 452, 455, 448, -30, -31, -32, -33, -34, -22,
 -35, -39, 464, 463, -36, -37, -60, -38, -40, -41,
 -23, -42, -43, -44, -45, -46, -47, -48, -49, -50,
 -51, -52, -53, -54, -55, -56, -57, -58, 305, 437,
 456, 457, 458, 459, 345, 346, 347, 344, 481, 482,
 483, 484, 485, 486, 487, 488, 489, 505, 490, 493,
 491, 492, 494, 497, 495, 496, 498, 499, 500, 501,
 502, 503, 506, 507, 508, 509, 510, 511, 512, 514,
 513, 515, 516, 517, 518, 519, 504, 520, 521, 522,
 360, 359, 362, 361, 370, 368, 369, 439, 364, 366,
 367, 363, 477, 476, 365, 445, 444, 395, 396, 417,
 415, 416, 465, 411, 413, 414, 412, 475, 474, 394,
 418, 271, 269, 274, 424, 393, 402, 401, 397, 403,
 405, 268, 267, 273, 392, 423, 400, 399, 398, 404,
 406, 391, 409, 407, 342, 340, 462, 460, 451, 450,
 449, 386, 385, 472, 471, 470, 469, 468, 467, 466,
 473, 276, 278, 280, 282, 275, 277, 279, 281, 285,
 284, 286, 287, 289, 288, 427, 436, 283, 290, 431,
 430, 429, 428, 435, 434, 433, 432, 358, 356, 357,
 355, 426, 378, 377, 375, 376, 383, 384, 371, 372,
 446, 373, 374, 379, 380, 447, 381, 382, 293, 294,
 295, 296, 301, 302, 303, 304, 266, 265, 272, 270,
 343, 341, 388, 387, 410, 408, 306, 307, 308, 309,
 310, 311, 390, 389, 315, 339, 313, 335, 329, 337,
 333, 323, 331, 325, 319, 321, 317, 327, 314, 338,
 312, 334, 328, 336, 332, 322, 330, 324, 318, 320,
 316, 326,  58, 258, 258, 258, -10,  -5, 261, -12,
 261, 262, -10, -10,  -2, 260,  -2, -10, -16, -19,
 262, 256, -16, -10, -10, -16,  -6,  -5, -12,  -6,
  -6, -20, -19, 259, -10, -10, -10, -10, -10,  -2,
 -10,  -2, -10,  -2, -10, -10,  -2, -10,  -2, -10,
  -2, -10,  -2,  -8,  -5, -10,  -2, -10,  -2, -10,
 -10, -10, -10, -65, 260, 256,  -8, -24, 259, 263,
 264, 260,  -8, -24,  -8, -24,  -8, -24,  -8, -24,
  -8, -24,  -8, -24, -65,  -8, -61,  -5, -65, -12,
  -7,  -5,  -7,  -7, -12, -16, -16, -16, -16, -20,
  -2,  40, -24, -24, 261, -24, 261, 260, 261,  -2,
  -2, 261,  -2, 261, 261, -59, 259, 263, 260, 256,
 -71, -73, 259, -74, 260, -76,  -3, 260, 259, 260,
 260, 260, 259, -78, 259,  -5, 260, -79, 260, 260,
 259, 259, 259, 261, 260, -59, 260, -59, -59, 259,
  -5, -80, -63,  40, -11, 260, 256, 259, -63, -64,
 -11, 263, 260, -63, -15,  91, -15, -64, 264, 264,
 -63, -63, -63, -63, -63, -63, -63, -63,  -8,  -8,
  -8,  -8,  -8, -15,  -8, -64, -15,  -8, 259, -15,
  -8, -64,  -8, -15,  -8, -64, -15,  -8, -15,  -8,
 -15,  -9,  -5,  -8, -15,  -8, -15,  -8,  -8,  -8,
  -8, -65, -65, -62,  91, -65, -65,  -9, -64, -25,
 259, 263, 264, 260,  -9, -64, -25,  -9, -64, -25,
  -9, -64, -25,  -9, -64, -25,  -8, -12, -12, -12,
 -20, -20, -21, -19, -21, -21, -15, -24, -15, -15,
 -15, 261, -72, 263, 256, -72, -75, -81, -59, -59,
 -77, -82, 264, 259, -59, 259, 263, -77, 259, 259,
 -75, -59, 259, 259, 259, 261, 259, 259, -75,  -5,
  40,  43,  40,  43,  45,  43,  45, 260, 259, 263,
 260, 260, -25,  -9, -64, -24,  -9, 259, -24, -64,
 259,  -9, -24,  -9, -64, -24,  -9, -64, -24,  -9,
 -64, -24,  -9, -64, -24,  -9, -64, -24,  -9, -64,
  -9, -64,  -9, -64,  -9, -64, 259, 263, 260, -65,
 -65, -65, -62, -65, -65, -65, -65, -65, -65, -65,
 -65, -65, -65, -65, -65, -21, -25,  41, 263, -59,
  58, 264,  -5, 259,  41,  -5, 260,  -5, -11, -11,
 -11, -11,  93,  93,  93, -25, -25, -25, -25, -25,
 -25, -25, -25,  93,  93,  93, 259,  41,  41,  40,
  40,  -5,  -5,  41,  41 };
short yydef[]={

   1,  -2,   4,   0,   0,   0,   0,   0,   7,   8,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,  26,   0,  28,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 241,
   0,   0,   0,   0,   0,   0,   0, 115,   0,   0,
 315, 317, 319,   0, 321,   0, 324, 325, 326, 413,
   0, 330,   0,   0,   0, 335,   0, 337,   0,   0,
   0, 342,   0,   0,   0,   0,   0,   0,   0,   0,
 352, 353,   0,   0,   0, 357, 358,   0,   0, 361,
 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
 160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
 180, 181, 182, 183, 184, 185, 186, 187, 188, 189,
 190, 191, 192, 193, 194, 195, 196, 197, 198, 199,
 200, 209, 210, 201, 202, 203, 204, 205, 206, 207,
 208, 211, 212, 213, 214, 215, 216, 217, 218, 219,
 220, 221, 222, 223, 224, 225, 226, 227, 228, 229,
 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
 240, 242, 243, 244, 245, 246, 247, 248, 249, 250,
 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
 261, 262, 263, 264, 265, 266, 267, 268, 269, 270,
 271, 272, 273, 274, 275, 276, 277, 278, 279, 280,
 281, 282, 283, 284, 285, 286, 287, 288, 289, 290,
 291, 292, 293, 294, 295, 296, 297, 298, 299, 300,
 301, 302, 303, 304, 305, 306, 307, 308, 309, 310,
 311, 312,   3,   2,   5,   6,   0, 380, 386,   0,
 392, 393,   0,   0, 132, 123, 132,   0,   0, 387,
 390, 391,   0,   0,   0,   0,   0, 385,   0,   0,
   0,   0, 388,  27,   0,   0,   0,   0,   0, 132,
   0, 132,   0, 132,   0,   0, 132,   0, 132,   0,
 132,   0, 132,   0, 381,   0, 132,   0, 132,   0,
   0,   0,   0,  65, 394, 395,   0,   0, 124, 125,
 126, 136,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  78,  79,   0,  -2,  81,   0,
  83, 384,  84,   0,   0,   0,   0,   0,   0,   0,
 132,   0, 103, 104, 108, 105, 109, 106, 107, 132,
 132, 113, 132, 114,   0, 314, 399, 400, 401, 402,
   0,   0, 320, 404,   0, 409, 328, 412, 329, 331,
   0,   0,   0, 409,   0,   0, 341, 404, 344,   0,
   0,   0,   0,   0, 350, 351, 354, 355, 356,   0,
   0, 404,   9,   0, 364, 366, 373, 379,  10,  11,
 374, 375, 376,  12,   0,   0,   0,  15,  16,  17,
  18,  19,  20,  21,  22,  23,  24,  25,  29,  30,
  31,  32,  33,   0,   0,  36,   0,   0,  39,   0,
   0,  41,   0,   0,   0,  46,   0,  47,   0,   0,
   0,  52, 382,   0,   0,   0,   0,   0,   0,   0,
   0,  66, 116, 127,   0,  67, 117,   0,   0,   0,
 128, 129, 130, 136,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,  80,  82,  85,  86,
  87,   0,  89, 389,  90,  91,   0,   0, 110, 111,
 112, 313, 316, 397, 398, 318, 322, 403, 406, 323,
 327, 408, 411, 332, 333, 334, 336, 338, 339,   0,
 343, 345, 346, 347, 348, 349, 359,   0, 362,   0,
   0,   0,   0,   0,   0,   0,   0,  14,   0,   0,
   0,  13, 100,  34,  35,   0,  37,  38,   0,  40,
  42,  43,   0,  44,  45,   0,  48,  49,   0,  50,
  51,   0,  53,  55,   0,  54,  56,   0,  57,  58,
  59,  60,  61,  62,  63,  64,   0,   0,   0,  68,
  69, 118, 131,  70,  71, 119,  72,  73, 120,  74,
  75, 121,  76,  77, 122,  88,  96,  97, 396, 405,
   0, 410, 340, 360, 363,   0, 369,   0, 368, 370,
 377, 378, 133, 134, 135,  99,  94,  95,  98, 101,
 102,  92,  93, 137, 138, 139, 407, 365, 367,   0,
   0,   0,   0, 371, 372 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 1:
# line 415 "parser.y"
{scanner_start_line ();} break;
case 3:
# line 418 "parser.y"
{
			   label *tmp;
			   abstract_line_label = tmp =
			     record_label (yypvt[-1].cptr,
					   (text_dir ? current_text_pc ()
					    : current_data_pc ()));
			     this_line_labels =
				cons_label(tmp, this_line_labels);
			 } break;
case 4:
# line 428 "parser.y"
{
		  abstract_line_label = NULL;
		} break;
case 5:
# line 435 "parser.y"
{
		  clear_labels ();
		  return (1);
		} break;
case 6:
# line 441 "parser.y"
{
		  clear_labels ();
		  return (1);
		} break;
case 7:
# line 447 "parser.y"
{
		  return (1);
		} break;
case 8:
# line 452 "parser.y"
{
		  clear_labels ();
		  return (0);
		} break;
case 9:
# line 461 "parser.y"
{
		  i_type_inst (yypvt[-2].ival == Y_LD_POP ? Y_LW_OP : yypvt[-2].ival,
			       yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr), 
			       addr_expr_imm (yypvt[-0].aeptr));
		  if (yypvt[-2].ival == Y_LD_POP) {
		    i_type_inst (Y_LW_OP, yypvt[-1].ival + 1, 
			 addr_expr_reg(yypvt[-0].aeptr),
			 incr_expr_offset(addr_expr_imm(yypvt[-0].aeptr), 4));
		  }
		  free (yypvt[-0].aeptr);
		} break;
case 10:
# line 474 "parser.y"
{
		  i_type_inst (yypvt[-2].ival, yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr), 
			       addr_expr_imm (yypvt[-0].aeptr));
		  free (yypvt[-0].aeptr);
		} break;
case 11:
# line 481 "parser.y"
{
		  i_type_inst (yypvt[-2].ival, yypvt[-1].ival, 0, yypvt[-0].ieptr);
		} break;
case 12:
# line 487 "parser.y"
{
		  if (addr_expr_reg (yypvt[-0].aeptr))
		    i_type_inst (Y_ADDI_OP, yypvt[-1].ival, 
				 addr_expr_reg(yypvt[-0].aeptr),
				 addr_expr_imm (yypvt[-0].aeptr));
		  else
		    i_type_inst (Y_LUI_OP, yypvt[-1].ival, 0, 
				 addr_expr_imm (yypvt[-0].aeptr));
		  free (yypvt[-0].aeptr);
		} break;
case 13:
# line 500 "parser.y"
{
		  i_type_inst (Y_ADDI_OP, A_DEST_RNUM, 0,
			addr_expr_imm(make_addr_expr(0, yypvt[-0].cptr, 0)));
		  Store(yypvt[-2].cptr, yypvt[-1].ival);
		} break;
case 14:
# line 508 "parser.y"
{
		  i_type_inst (Y_ADDI_OP, A_DEST_RNUM, 0,
			addr_expr_imm(make_addr_expr(0, yypvt[-0].cptr, 0)));
		  Store(yypvt[-2].cptr, yypvt[-1].ival);
		} break;
case 15:
# line 516 "parser.y"
{
		  i_type_inst (Y_ORI_OP, yypvt[-1].ival, 0, yypvt[-0].ieptr);
		} break;
case 16:
# line 522 "parser.y"
{
		  int *x = (int *) yypvt[-0].dptr;

		  i_type_inst (Y_ORI_OP, 1, 0, const_imm_expr (*x));
		  r_type_inst (Y_MTC1_OP, yypvt[-1].ival, 0, 1);
		  i_type_inst (Y_ORI_OP, 1, 0, const_imm_expr (*(x+1)));
		  r_type_inst (Y_MTC1_OP, yypvt[-1].ival + 1, 0, 1);
		} break;
case 17:
# line 533 "parser.y"
{
		  float x = *yypvt[-0].dptr;
		  int *y = (int *) &x;

		  i_type_inst (Y_ORI_OP, 1, 0, const_imm_expr (*y));
		  r_type_inst (Y_MTC1_OP, yypvt[-1].ival, 0, 1);
		} break;
case 18:
# line 543 "parser.y"
{
		  if (IS_BIG_ENDIAN) {
		    i_type_inst (Y_LWL_OP, yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr),
				 addr_expr_imm (yypvt[-0].aeptr));
		    i_type_inst (Y_LWR_OP, yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr),
		      incr_expr_offset (addr_expr_imm (yypvt[-0].aeptr), 3));
		  } else {
		    i_type_inst (Y_LWL_OP, yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr),
			incr_expr_offset (addr_expr_imm (yypvt[-0].aeptr), 3));
		    i_type_inst (Y_LWR_OP, yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr),
				 addr_expr_imm (yypvt[-0].aeptr));
		  }
		  free (yypvt[-0].aeptr);
		} break;
case 19:
# line 560 "parser.y"
{
		  if (IS_BIG_ENDIAN) {
		    i_type_inst ((yypvt[-2].ival == Y_ULH_POP ? Y_LB_OP : Y_LBU_OP),
				 yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr),
				 addr_expr_imm (yypvt[-0].aeptr));
		    i_type_inst (Y_LBU_OP, 1, addr_expr_reg (yypvt[-0].aeptr),
		      incr_expr_offset (addr_expr_imm (yypvt[-0].aeptr), 1));
		  } else {
		    i_type_inst ((yypvt[-2].ival == Y_ULH_POP ? Y_LB_OP : Y_LBU_OP),
				 yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr),
			incr_expr_offset (addr_expr_imm (yypvt[-0].aeptr), 1));
		    i_type_inst (Y_LBU_OP, 1, addr_expr_reg (yypvt[-0].aeptr),
				 addr_expr_imm (yypvt[-0].aeptr));
		  }
		  r_sh_type_inst (Y_SLL_OP, yypvt[-1].ival, yypvt[-1].ival, 8);
		  r_type_inst (Y_OR_OP, yypvt[-1].ival, yypvt[-1].ival, 1);
		  free (yypvt[-0].aeptr);
		} break;
case 20:
# line 581 "parser.y"
{
		  i_type_inst (Y_LWC1_OP, yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr),
			       addr_expr_imm (yypvt[-0].aeptr));
		  if (yypvt[-2].ival == Y_L_D_POP) {
		    i_type_inst (Y_LWC1_OP, yypvt[-1].ival + 1, 
		      addr_expr_reg (yypvt[-0].aeptr),
		      incr_expr_offset (addr_expr_imm (yypvt[-0].aeptr), 4));
		  }
		  free (yypvt[-0].aeptr);
		} break;
case 21:
# line 594 "parser.y"
{
		  i_type_inst (yypvt[-2].ival == Y_SD_POP ? Y_SW_OP : yypvt[-2].ival,
			       yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr), 
			       addr_expr_imm (yypvt[-0].aeptr));
		  if (yypvt[-2].ival == Y_SD_POP) {
		    i_type_inst (Y_SW_OP, yypvt[-1].ival + 1, 
		      addr_expr_reg (yypvt[-0].aeptr),
		      incr_expr_offset (addr_expr_imm (yypvt[-0].aeptr), 4));
		  }
		  free (yypvt[-0].aeptr);
		} break;
case 22:
# line 608 "parser.y"
{
		  i_type_inst (yypvt[-2].ival, yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr), 
			       addr_expr_imm (yypvt[-0].aeptr));
		  free (yypvt[-0].aeptr);
		} break;
case 23:
# line 616 "parser.y"
{
		  if (IS_BIG_ENDIAN) {
		    i_type_inst (Y_SWL_OP, yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr),
				 addr_expr_imm (yypvt[-0].aeptr));
		    i_type_inst (Y_SWR_OP, yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr),
			incr_expr_offset (addr_expr_imm (yypvt[-0].aeptr), 3));
		  } else {
		    i_type_inst (Y_SWL_OP, yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr),
			incr_expr_offset (addr_expr_imm (yypvt[-0].aeptr), 3));
		    i_type_inst (Y_SWR_OP, yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr),
				 addr_expr_imm (yypvt[-0].aeptr));
		  }
		  free (yypvt[-0].aeptr);
		} break;
case 24:
# line 633 "parser.y"
{
		  i_type_inst (Y_SB_OP, yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr),
			       addr_expr_imm (yypvt[-0].aeptr));
		  r_sh_type_inst (Y_SRL_OP, 1, yypvt[-1].ival, 8);
		  i_type_inst (Y_SB_OP, 1, addr_expr_reg (yypvt[-0].aeptr),
		       incr_expr_offset (addr_expr_imm (yypvt[-0].aeptr), 1));
		  free (yypvt[-0].aeptr);
		} break;
case 25:
# line 644 "parser.y"
{
		  i_type_inst (Y_SWC1_OP, yypvt[-1].ival, addr_expr_reg (yypvt[-0].aeptr),
			       addr_expr_imm (yypvt[-0].aeptr));
		  if (yypvt[-2].ival == Y_S_D_POP) {
		    i_type_inst (Y_SWC1_OP, yypvt[-1].ival + 1, 
		      addr_expr_reg (yypvt[-0].aeptr),
		      incr_expr_offset (addr_expr_imm (yypvt[-0].aeptr), 4));
		  }
		  free (yypvt[-0].aeptr);
		} break;
case 26:
# line 657 "parser.y"
{
		  r_type_inst (yypvt[-0].ival, 0, 0, 0);
		} break;
case 27:
# line 663 "parser.y"
{
		  if (yypvt[-0].ival == 1)
		    yyerror ("Breakpoint 1 is reserved for debugger\n");
		  r_type_inst (yypvt[-1].ival, yypvt[-0].ival, 0, 0);
		} break;
case 28:
# line 671 "parser.y"
{
		  nop_inst ();
		} break;
case 29:
# line 677 "parser.y"
{
		  if (yypvt[-1].ival != yypvt[-0].ival)
		    r_type_inst (Y_ADDU_OP, yypvt[-1].ival, 0, yypvt[-0].ival);

		  i_type_inst (Y_BGEZ_OP, 0, yypvt[-0].ival, branch_offset (2));
		  r_type_inst (Y_SUB_OP, yypvt[-1].ival, 0, yypvt[-0].ival);
		} break;
case 30:
# line 687 "parser.y"
{
		  r_type_inst (Y_SUB_OP, yypvt[-1].ival, 0, yypvt[-0].ival);
		} break;
case 31:
# line 693 "parser.y"
{
		  r_type_inst (Y_SUBU_OP, yypvt[-1].ival, 0, yypvt[-0].ival);
		} break;
case 32:
# line 699 "parser.y"
{
		  r_type_inst (Y_NOR_OP, yypvt[-1].ival, yypvt[-0].ival, 0);
		} break;
case 33:
# line 705 "parser.y"
{
		  r_type_inst (Y_ADDU_OP, yypvt[-1].ival, 0, yypvt[-0].ival);
		} break;
case 34:
# line 711 "parser.y"
{
		  r_type_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival);
		} break;
case 35:
# line 717 "parser.y"
{
		  i_type_inst (op_to_imm_op (yypvt[-3].ival), yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ieptr);
		} break;
case 36:
# line 723 "parser.y"
{
		  i_type_inst (op_to_imm_op (yypvt[-2].ival), yypvt[-1].ival, yypvt[-1].ival, yypvt[-0].ieptr);
		} break;
case 37:
# line 729 "parser.y"
{
		  r_type_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-0].ival, yypvt[-1].ival);
		} break;
case 38:
# line 735 "parser.y"
{
		  r_sh_type_inst (op_to_imm_op(yypvt[-3].ival), yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival);
		} break;
case 39:
# line 741 "parser.y"
{
		  r_sh_type_inst (op_to_imm_op(yypvt[-2].ival), yypvt[-1].ival, yypvt[-1].ival, yypvt[-0].ival);
		} break;
case 40:
# line 747 "parser.y"
{
		  i_type_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ieptr);
		} break;
case 41:
# line 753 "parser.y"
{
		  i_type_inst (yypvt[-2].ival, yypvt[-1].ival, yypvt[-1].ival, yypvt[-0].ieptr);
		} break;
case 42:
# line 759 "parser.y"
{
		  r_sh_type_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival);
		} break;
case 43:
# line 765 "parser.y"
{
		  r_type_inst (imm_op_to_op(yypvt[-3].ival), yypvt[-2].ival, yypvt[-0].ival, yypvt[-1].ival);
		} break;
case 44:
# line 771 "parser.y"
{
		  r_type_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival);
		} break;
case 45:
# line 777 "parser.y"
{
		  if (bare_machine)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    {
		      if (!zero_imm (yypvt[-0].ieptr))
			i_type_inst (Y_ORI_OP, 1, 0, yypvt[-0].ieptr); /* Use $at */
		      r_type_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, 
				   (zero_imm (yypvt[-0].ieptr) ? 0 : 1));
		    }
		} break;
case 46:
# line 791 "parser.y"
{
		  if (bare_machine)
		    yyerror ("Immediate form not allowed in bare machine");
		  else
		    {
		      if (!zero_imm (yypvt[-0].ieptr))
			i_type_inst (Y_ORI_OP, 1, 0, yypvt[-0].ieptr); /* Use $at */
		      r_type_inst (yypvt[-2].ival, yypvt[-1].ival, yypvt[-1].ival, 
				   (zero_imm (yypvt[-0].ieptr) ? 0 : 1));
		    }
		} break;
case 47:
# line 805 "parser.y"
{
		  /* The hardware divide operation (ignore 1st arg) */
		  if (yypvt[-2].ival != Y_DIV_OP && yypvt[-2].ival != Y_DIVU_OP)
		    yyerror ("Syntax error");
		  r_type_inst (yypvt[-2].ival, 0, yypvt[-1].ival, yypvt[-0].ival);
		} break;
case 48:
# line 813 "parser.y"
{
		  /* Pseudo divide operations */
		  div_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival, 0);
		} break;
case 49:
# line 819 "parser.y"
{
		  if (zero_imm (yypvt[-0].ieptr))
		    yyerror ("Divide by zero");
		  else
		    {
		      i_type_inst (Y_ORI_OP, 1, 0, yypvt[-0].ieptr); /* Use $at */
		      div_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, 1, 1);
		    }
		} break;
case 50:
# line 831 "parser.y"
{
		  mult_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival);
		} break;
case 51:
# line 836 "parser.y"
{
		  if (zero_imm (yypvt[-0].ieptr))
		    r_type_inst (Y_ORI_OP, yypvt[-2].ival, 0, 0);
		  else
		    {
		      i_type_inst (Y_ORI_OP, 1, 0, yypvt[-0].ieptr); /* Use $at */
		      mult_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, 1);
		    }
		} break;
case 52:
# line 848 "parser.y"
{
		  r_type_inst (yypvt[-2].ival, 0, yypvt[-1].ival, yypvt[-0].ival);
		} break;
case 53:
# line 854 "parser.y"
{
		  r_type_inst (Y_SUBU_OP, 1, 0, yypvt[-0].ival);
		  r_type_inst (Y_SLLV_OP, 1, 1, yypvt[-1].ival);
		  r_type_inst (Y_SRLV_OP, yypvt[-2].ival, yypvt[-0].ival, yypvt[-1].ival);
		  r_type_inst (Y_OR_OP, yypvt[-2].ival, yypvt[-2].ival, 1);
		} break;
case 54:
# line 863 "parser.y"
{
		  r_type_inst (Y_SUBU_OP, 1, 0, yypvt[-0].ival);
		  r_type_inst (Y_SRLV_OP, 1, 1, yypvt[-1].ival);
		  r_type_inst (Y_SLLV_OP, yypvt[-2].ival, yypvt[-0].ival, yypvt[-1].ival);
		  r_type_inst (Y_OR_OP, yypvt[-2].ival, yypvt[-2].ival, 1);
		} break;
case 55:
# line 872 "parser.y"
{
		  long dist = eval_imm_expr (yypvt[-0].ieptr);

		  r_sh_type_inst (Y_SLL_OP, 1, yypvt[-1].ival, -dist);
		  r_sh_type_inst (Y_SRL_OP, yypvt[-2].ival, yypvt[-1].ival, dist);
		  r_type_inst (Y_OR_OP, yypvt[-2].ival, yypvt[-2].ival, 1);
		} break;
case 56:
# line 882 "parser.y"
{
		  long dist = eval_imm_expr (yypvt[-0].ieptr);

		  r_sh_type_inst (Y_SRL_OP, 1, yypvt[-1].ival, -dist);
		  r_sh_type_inst (Y_SLL_OP, yypvt[-2].ival, yypvt[-1].ival, dist);
		  r_type_inst (Y_OR_OP, yypvt[-2].ival, yypvt[-2].ival, 1);
		} break;
case 57:
# line 893 "parser.y"
{
		  set_le_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival);
		} break;
case 58:
# line 898 "parser.y"
{
		  if (!zero_imm (yypvt[-0].ieptr))
		    i_type_inst (Y_ORI_OP, 1, 0, yypvt[-0].ieptr); /* Use $at */
		  set_le_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, (zero_imm (yypvt[-0].ieptr) ? 0 : 1));
		} break;
case 59:
# line 906 "parser.y"
{
		  set_gt_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival);
		} break;
case 60:
# line 911 "parser.y"
{
		  if (!zero_imm (yypvt[-0].ieptr))
		    i_type_inst (Y_ORI_OP, 1, 0, yypvt[-0].ieptr); /* Use $at */
		  set_gt_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, (zero_imm (yypvt[-0].ieptr) ? 0 : 1));
		} break;
case 61:
# line 920 "parser.y"
{
		  set_ge_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival);
		} break;
case 62:
# line 925 "parser.y"
{
		  if (!zero_imm (yypvt[-0].ieptr))
		    i_type_inst (Y_ORI_OP, 1, 0, yypvt[-0].ieptr); /* Use $at */
		  set_ge_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, (zero_imm (yypvt[-0].ieptr) ? 0 : 1));
		} break;
case 63:
# line 933 "parser.y"
{
		  set_eq_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival);
		} break;
case 64:
# line 938 "parser.y"
{
		  if (!zero_imm (yypvt[-0].ieptr))
		    i_type_inst (Y_ORI_OP, 1, 0, yypvt[-0].ieptr); /* Use $at */
		  set_eq_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, (zero_imm (yypvt[-0].ieptr) ? 0 : 1));
		} break;
case 65:
# line 946 "parser.y"
{
		  i_type_inst (yypvt[-1].ival, 0, 0, yypvt[-0].ieptr);
		} break;
case 66:
# line 952 "parser.y"
{
		  i_type_inst (yypvt[-2].ival, 0, yypvt[-1].ival, yypvt[-0].ieptr);
		} break;
case 67:
# line 958 "parser.y"
{
		  i_type_inst (yypvt[-2].ival == Y_BEQZ_POP ? Y_BEQ_OP : Y_BNE_OP,
			       0, yypvt[-1].ival, yypvt[-0].ieptr);
		} break;
case 68:
# line 965 "parser.y"
{
		  i_type_inst (yypvt[-3].ival, yypvt[-1].ival, yypvt[-2].ival, yypvt[-0].ieptr);
		} break;
case 69:
# line 970 "parser.y"
{
		  if (bare_machine)
		    yyerror ("Immediate form not allowed on bare machine");
		  else
		    {
		      if (zero_imm (yypvt[-1].ieptr))
			i_type_inst (yypvt[-3].ival, yypvt[-2].ival, (zero_imm (yypvt[-1].ieptr) ? 0 : 1), yypvt[-0].ieptr);
		      else
			{
			  i_type_inst (Y_ORI_OP, 1, 0, yypvt[-1].ieptr); /* Use $at */
			  i_type_inst (yypvt[-3].ival, yypvt[-2].ival, (zero_imm (yypvt[-1].ieptr) ? 0 : 1), yypvt[-0].ieptr);
			}
		    }
		} break;
case 70:
# line 987 "parser.y"
{
		  r_type_inst (yypvt[-3].ival == Y_BGT_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-1].ival, yypvt[-2].ival); /* Use $at */
		  i_type_inst (Y_BNE_OP, 0, 1, yypvt[-0].ieptr);
		} break;
case 71:
# line 994 "parser.y"
{
		  if (yypvt[-3].ival == Y_BGT_POP)
		    {
		      /* Use $at */
		      i_type_inst (Y_SLTI_OP, 1, yypvt[-2].ival, 
				   incr_expr_offset (yypvt[-1].ieptr, 1));
		      i_type_inst (Y_BEQ_OP, 0, 1, yypvt[-0].ieptr);
		    }
		  else
		    {
		      /* Use $at */
		      /* Can't add 1 to immediate since 0xffffffff+1 = 0 < 1 */
		      i_type_inst (Y_ORI_OP, 1, 0, yypvt[-1].ieptr);
		      i_type_inst (Y_BEQ_OP, yypvt[-2].ival, 1, branch_offset (3));
		      r_type_inst (Y_SLTU_OP, 1, yypvt[-2].ival, 1);
		      i_type_inst (Y_BEQ_OP, 0, 1, yypvt[-0].ieptr);
		    }
		} break;
case 72:
# line 1015 "parser.y"
{
		  r_type_inst (yypvt[-3].ival == Y_BGE_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-2].ival, yypvt[-1].ival); /* Use $at */
		  i_type_inst (Y_BEQ_OP, 0, 1, yypvt[-0].ieptr);
		} break;
case 73:
# line 1022 "parser.y"
{
		  i_type_inst (yypvt[-3].ival == Y_BGE_POP ? Y_SLTI_OP : Y_SLTIU_OP,
			       1, yypvt[-2].ival, yypvt[-1].ieptr); /* Use $at */
		  i_type_inst (Y_BEQ_OP, 0, 1, yypvt[-0].ieptr);
		} break;
case 74:
# line 1030 "parser.y"
{
		  r_type_inst (yypvt[-3].ival == Y_BLT_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-2].ival, yypvt[-1].ival); /* Use $at */
		  i_type_inst (Y_BNE_OP, 0, 1, yypvt[-0].ieptr);
		} break;
case 75:
# line 1037 "parser.y"
{
		  i_type_inst (yypvt[-3].ival == Y_BLT_POP ? Y_SLTI_OP : Y_SLTIU_OP,
			       1, yypvt[-2].ival, yypvt[-1].ieptr); /* Use $at */
		  i_type_inst (Y_BNE_OP, 0, 1, yypvt[-0].ieptr);
		} break;
case 76:
# line 1045 "parser.y"
{
		  r_type_inst (yypvt[-3].ival == Y_BLE_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, yypvt[-1].ival, yypvt[-2].ival); /* Use $at */
		  i_type_inst (Y_BEQ_OP, 0, 1, yypvt[-0].ieptr);
		} break;
case 77:
# line 1052 "parser.y"
{
		  if (yypvt[-3].ival == Y_BLE_POP)
		    {
		      /* Use $at */
		      i_type_inst (Y_SLTI_OP, 1, yypvt[-2].ival, 
				   incr_expr_offset (yypvt[-1].ieptr, 1));
		      i_type_inst (Y_BNE_OP, 0, 1, yypvt[-0].ieptr);
		    }
		  else
		    {
		      /* Use $at */
		      /* Can't add 1 to immediate since 0xffffffff+1 = 0 < 1 */
		      i_type_inst (Y_ORI_OP, 1, 0, yypvt[-1].ieptr);
		      i_type_inst (Y_BEQ_OP, yypvt[-2].ival, 1, 
				   copy_imm_expr (yypvt[-0].ieptr));
		      r_type_inst (Y_SLTU_OP, 1, yypvt[-2].ival, 1);
		      i_type_inst (Y_BNE_OP, 0, 1, yypvt[-0].ieptr);
		    }
		} break;
case 78:
# line 1074 "parser.y"
{
		  if ((yypvt[-1].ival == Y_J_OP) || (yypvt[-1].ival == Y_JR_OP))
		    j_type_inst (Y_J_OP, yypvt[-0].ieptr);
		  else if ((yypvt[-1].ival == Y_JAL_OP) || (yypvt[-1].ival == Y_JALR_OP))
		    j_type_inst (Y_JAL_OP, yypvt[-0].ieptr);
		} break;
case 79:
# line 1083 "parser.y"
{
		  if ((yypvt[-1].ival == Y_J_OP) || (yypvt[-1].ival == Y_JR_OP))
		    r_type_inst (Y_JR_OP, 0, yypvt[-0].ival, 0);
		  else if ((yypvt[-1].ival == Y_JAL_OP) || (yypvt[-1].ival == Y_JALR_OP))
		    r_type_inst (Y_JALR_OP, 31, yypvt[-0].ival, 0);
		} break;
case 80:
# line 1092 "parser.y"
{
		  if ((yypvt[-2].ival == Y_J_OP) || (yypvt[-2].ival == Y_JR_OP))
		    r_type_inst (Y_JR_OP, 0, yypvt[-0].ival, 0);
		  else if ((yypvt[-2].ival == Y_JAL_OP) || (yypvt[-2].ival == Y_JALR_OP))
		    r_type_inst (Y_JALR_OP, yypvt[-1].ival, yypvt[-0].ival, 0);
		} break;
case 81:
# line 1100 "parser.y"
{
		  i_type_inst ((yypvt[-1].ival == Y_BAL_POP ? Y_BGEZAL_OP : Y_BGEZ_OP),
			       0, 0, yypvt[-0].ieptr);
		} break;
case 82:
# line 1108 "parser.y"
{
		  r_type_inst (yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival, 0);
		} break;
case 83:
# line 1114 "parser.y"
{
		  r_type_inst (yypvt[-1].ival, yypvt[-0].ival, 0, 0);
		} break;
case 84:
# line 1120 "parser.y"
{
		  r_type_inst (yypvt[-1].ival, 0, yypvt[-0].ival, 0);
		} break;
case 85:
# line 1126 "parser.y"
{
		  if (yypvt[-2].ival == Y_MFC1_D_POP)
		    {
		      r_type_inst (Y_MFC1_OP, yypvt[-0].ival, 0, yypvt[-1].ival);
		      r_type_inst (Y_MFC1_OP, yypvt[-0].ival + 1, 0, yypvt[-1].ival + 1);
		    }
		  else if (yypvt[-2].ival == Y_MTC1_D_POP)
		    {
		      r_type_inst (Y_MTC1_OP, yypvt[-0].ival, 0, yypvt[-1].ival);
		      r_type_inst (Y_MTC1_OP, yypvt[-0].ival + 1, 0, yypvt[-1].ival + 1);
		    }
		  else
		    r_type_inst (yypvt[-2].ival, yypvt[-0].ival, 0, yypvt[-1].ival);
		} break;
case 86:
# line 1143 "parser.y"
{
		  r_type_inst (yypvt[-2].ival, yypvt[-0].ival, 0, yypvt[-1].ival);
		} break;
case 87:
# line 1149 "parser.y"
{
		  r_type_inst (yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival, 0);
		} break;
case 88:
# line 1155 "parser.y"
{
		  r_type_inst (yypvt[-3].ival, yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival);
		} break;
case 89:
# line 1161 "parser.y"
{
		  r_type_inst (yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival, 0);
		} break;
case 90:
# line 1167 "parser.y"
{
		  r_type_inst (yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival, 0);
		} break;
case 91:
# line 1173 "parser.y"
{
		  r_cond_type_inst (yypvt[-2].ival, yypvt[-1].ival, yypvt[-0].ival);
		} break;
case 92:
# line 1178 "parser.y"
{
		  if (((get_label_type(yypvt[-3].cptr) != WORD_A_TYPE) &&
		       (get_label_type(yypvt[-3].cptr) != BYTE_A_TYPE)) ||
		      ((yypvt[-1].ival != WORD_A_TYPE) && (yypvt[-1].ival != BYTE_A_TYPE)) ||
		      ((yypvt[-0].ival != WORD_A_TYPE) && (yypvt[-0].ival != BYTE_A_TYPE)))
		    yyerror("ROR must use .byte or .word\n");
		  r_type_inst (Y_SUBU_OP, 1, 0, A_SRC2_RNUM);
		  r_type_inst (Y_SLLV_OP, 1, 1, A_SRC1_RNUM);
		  r_type_inst (Y_SRLV_OP, A_DEST_RNUM, A_SRC2_RNUM,A_SRC1_RNUM);
		  r_type_inst (Y_OR_OP, A_DEST_RNUM, A_DEST_RNUM, 1);
		  Store(yypvt[-3].cptr, yypvt[-2].ival);
		} break;
case 93:
# line 1192 "parser.y"
{
		  if (((get_label_type(yypvt[-3].cptr) != WORD_A_TYPE) &&
		       (get_label_type(yypvt[-3].cptr) != BYTE_A_TYPE)) ||
		      ((yypvt[-1].ival != WORD_A_TYPE) && (yypvt[-1].ival != BYTE_A_TYPE)) ||
		      ((yypvt[-0].ival != WORD_A_TYPE) && (yypvt[-0].ival != BYTE_A_TYPE)))
		    yyerror("ROR must use .byte or .word\n");
		  r_type_inst (Y_SUBU_OP, 1, 0, A_SRC2_RNUM);
		  r_type_inst (Y_SRLV_OP, 1, 1, A_SRC1_RNUM);
		  r_type_inst (Y_SLLV_OP, A_DEST_RNUM, A_SRC2_RNUM,A_SRC1_RNUM);
		  r_type_inst (Y_OR_OP, A_DEST_RNUM, A_DEST_RNUM, 1);
		  Store(yypvt[-3].cptr, yypvt[-2].ival);
		} break;
case 94:
# line 1206 "parser.y"
{
		  if (((get_label_type(yypvt[-3].cptr) != WORD_A_TYPE) &&
		       (get_label_type(yypvt[-3].cptr) != BYTE_A_TYPE)) ||
		      ((yypvt[-1].ival != WORD_A_TYPE) && (yypvt[-1].ival != BYTE_A_TYPE)) ||
		      ((yypvt[-0].ival != WORD_A_TYPE) && (yypvt[-0].ival != BYTE_A_TYPE)))
		    yyerror("Shift must use .byte or .word\n");
		  r_type_inst (yypvt[-4].ival, A_DEST_RNUM, A_SRC2_RNUM, A_SRC1_RNUM);
		  Store(yypvt[-3].cptr, yypvt[-2].ival);
		} break;
case 95:
# line 1217 "parser.y"
{
		  if (((get_label_type(yypvt[-3].cptr) != WORD_A_TYPE) &&
		       (get_label_type(yypvt[-3].cptr) != BYTE_A_TYPE)) ||
		      ((yypvt[-1].ival != WORD_A_TYPE) && (yypvt[-1].ival != BYTE_A_TYPE)) ||
		      ((yypvt[-0].ival != WORD_A_TYPE) && (yypvt[-0].ival != BYTE_A_TYPE)))
		    yyerror("Shift must use .byte or .word\n");
		  r_type_inst (imm_op_to_op(yypvt[-4].ival),
				      A_DEST_RNUM, A_SRC2_RNUM, A_SRC1_RNUM);
		  Store(yypvt[-3].cptr, yypvt[-2].ival);
		} break;
case 96:
# line 1229 "parser.y"
{
		  if (get_label_type(yypvt[-2].cptr) == FLOAT_A_TYPE) {
		    if ((yypvt[-0].ival != WORD_A_TYPE) && (yypvt[-0].ival != BYTE_A_TYPE))
		      yyerror("Type mismatch");
		    r_type_inst(Y_MTC1_OP, AF_DEST_RNUM, 0, A_SRC2_RNUM);
		    r_type_inst(Y_CVT_S_W_OP, AF_SRC2_RNUM, AF_SRC2_RNUM, 0);
		  }
		  else if ((get_label_type(yypvt[-2].cptr) == WORD_A_TYPE) ||
				(get_label_type(yypvt[-2].cptr) == BYTE_A_TYPE)) {
		    if (yypvt[-0].ival != FLOAT_A_TYPE)
		      yyerror("Type mismatch");
		    r_type_inst(Y_CVT_W_S_OP, AF_SRC2_RNUM, AF_SRC2_RNUM, 0);
		    r_type_inst(Y_MFC1_OP, AF_SRC2_RNUM, 0, A_DEST_RNUM);
		  }
		  else yyerror("Unknown type");
		  Store(yypvt[-2].cptr, yypvt[-1].ival);
		} break;
case 97:
# line 1248 "parser.y"
{
		  if (yypvt[-1].ival != WORD_A_TYPE) {
		      yyerror("Type mismatch.  In b (label), the label must be a .word\n");
		  }
		  r_type_inst(Y_JR_OP, 0, A_SRC1_RNUM, 0);
		} break;
case 98:
# line 1256 "parser.y"
{
		  if (BadTypes(get_label_type(yypvt[-3].cptr), yypvt[-1].ival, yypvt[-0].ival))
		      yyerror("Type mismatch");
		  switch (get_label_type(yypvt[-3].cptr)) {
		    case WORD_A_TYPE:
		    case BYTE_A_TYPE:
		      r_type_inst (yypvt[-4].ival, A_DEST_RNUM, A_SRC1_RNUM, A_SRC2_RNUM);
		      break;
		    case FLOAT_A_TYPE:
		      r_type_inst (op_to_float_op(yypvt[-4].ival), AF_DEST_RNUM, AF_SRC1_RNUM, AF_SRC2_RNUM);
		      break;
		    case DOUBLE_A_TYPE:
		      r_type_inst (op_to_double_op(yypvt[-4].ival), AF_DEST_RNUM, AF_SRC1_RNUM, AF_SRC2_RNUM);
		      break;
		    default:
		      yyerror ("Unknown type");
		  }
		  Store(yypvt[-3].cptr, yypvt[-2].ival);
		} break;
case 99:
# line 1277 "parser.y"
{
		  if (BadTypes(get_label_type(yypvt[-3].cptr), yypvt[-1].ival, yypvt[-0].ival))
		      yyerror("Type mismatch");
		  switch (get_label_type(yypvt[-3].cptr)) {
		    case WORD_A_TYPE:
		    case BYTE_A_TYPE:
		      r_type_inst (yypvt[-4].ival, A_DEST_RNUM, A_SRC1_RNUM, A_SRC2_RNUM);
		      break;
		    case FLOAT_A_TYPE:
		      r_type_inst (op_to_float_op(yypvt[-4].ival), AF_DEST_RNUM, AF_SRC1_RNUM, AF_SRC2_RNUM);
		      break;
		    case DOUBLE_A_TYPE:
		      r_type_inst (op_to_double_op(yypvt[-4].ival), AF_DEST_RNUM, AF_SRC1_RNUM, AF_SRC2_RNUM);
		      break;
		    default:
		      yyerror ("Unknown type");
		  }
		  Store(yypvt[-3].cptr, yypvt[-2].ival);
		} break;
case 100:
# line 1298 "parser.y"
{
		  /* Source must be A_SRC2, because A_SRC2_RNUM = A_DEST_RNUM */
		  switch (get_label_type(yypvt[-2].cptr)) {
		    case WORD_A_TYPE:
		    case BYTE_A_TYPE:
		      if (yypvt[-0].ival == FLOAT_A_TYPE)
		        r_type_inst(Y_MFC1_OP, AF_SRC2_RNUM, 0, A_DEST_RNUM);
		      else if ((yypvt[-0].ival != WORD_A_TYPE) && (yypvt[-0].ival != BYTE_A_TYPE))
			yyerror("Type mismatch");
		      break;
		    case DOUBLE_A_TYPE:
		      if (yypvt[-0].ival != DOUBLE_A_TYPE)
		        yyerror("Type mismatch");
			  break;
		    case FLOAT_A_TYPE:
		      if ((yypvt[-0].ival == WORD_A_TYPE) || (yypvt[-0].ival == BYTE_A_TYPE))
			r_type_inst(Y_MTC1_OP, AF_DEST_RNUM, 0, A_SRC2_RNUM);
		      else if (yypvt[-0].ival != FLOAT_A_TYPE)
			yyerror("Type mismatch");
		      break;
		    default:
		      yyerror ("Unknown type");
		  }
		  Store(yypvt[-2].cptr, yypvt[-1].ival);
		} break;
case 101:
# line 1325 "parser.y"
{
		  if (BadTypes(get_label_type(yypvt[-3].cptr), yypvt[-1].ival, yypvt[-0].ival))
		      yyerror("Type mismatch");
		  switch (get_label_type(yypvt[-3].cptr)) {
		    case WORD_A_TYPE:
		      div_inst (yypvt[-4].ival, A_DEST_RNUM, A_SRC1_RNUM, A_SRC2_RNUM, 0);
		      break;
		    case BYTE_A_TYPE:
		      div_inst (yypvt[-4].ival, A_DEST_RNUM, A_SRC1_RNUM, A_SRC2_RNUM, 0);
		      break;
		    case FLOAT_A_TYPE:
		      r_type_inst (op_to_float_op(yypvt[-4].ival), AF_DEST_RNUM, AF_SRC1_RNUM, AF_SRC2_RNUM);
		      break;
		    case DOUBLE_A_TYPE:
		      r_type_inst (op_to_double_op(yypvt[-4].ival), AF_DEST_RNUM, AF_SRC1_RNUM, AF_SRC2_RNUM);
		      break;
		    default:
		      yyerror ("Unknown type");
		  }
		  Store(yypvt[-3].cptr, yypvt[-2].ival);
		} break;
case 102:
# line 1348 "parser.y"
{
		  if (BadTypes(get_label_type(yypvt[-3].cptr), yypvt[-1].ival, yypvt[-0].ival))
		      yyerror("Type mismatch");
		  switch (get_label_type(yypvt[-3].cptr)) {
		    case WORD_A_TYPE:
		      mult_inst (Y_MUL_POP, A_DEST_RNUM, A_SRC1_RNUM, A_SRC2_RNUM);
		      break;
		    case BYTE_A_TYPE:
		      mult_inst (Y_MUL_POP, A_DEST_RNUM, A_SRC1_RNUM, A_SRC2_RNUM);
		      break;
		    case FLOAT_A_TYPE:
		      r_type_inst (op_to_float_op(yypvt[-4].ival), AF_DEST_RNUM, AF_SRC1_RNUM, AF_SRC2_RNUM);
		      break;
		    case DOUBLE_A_TYPE:
		      r_type_inst (op_to_double_op(yypvt[-4].ival), AF_DEST_RNUM, AF_SRC1_RNUM, AF_SRC2_RNUM);
		      break;
		    default:
		      yyerror ("Unknown type");
		  }
		  Store(yypvt[-3].cptr, yypvt[-2].ival);
		} break;
case 103:
# line 1371 "parser.y"
{
		  switch (yypvt[-0].ival) {
		    case BYTE_A_TYPE:
		      i_type_inst(Y_ORI_OP, 2, 0, make_imm_expr (11, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    case WORD_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (1, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    case FLOAT_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (2, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    case DOUBLE_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (3, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    default:
		      yyerror ("Unknown type");
		  }
		} break;
case 104:
# line 1395 "parser.y"
{
		  switch (yypvt[-0].ival) {
		    case BYTE_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (11, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    case WORD_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (11, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    case FLOAT_A_TYPE:
		    case DOUBLE_A_TYPE:
		    default:
		      yyerror ("Bad type in putc, must be byte or word.");
		  }
		} break;
case 105:
# line 1413 "parser.y"
{
		  switch (yypvt[-0].ival) {
		    case BYTE_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (1, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    case WORD_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (1, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    case FLOAT_A_TYPE:
		    case DOUBLE_A_TYPE:
		    default:
		      yyerror ("Bad type in puti, must be byte or word.");
		  }
		} break;
case 106:
# line 1431 "parser.y"
{
		  i_type_inst (Y_ADDI_OP, A_SRC1_RNUM, 0, 
		       addr_expr_imm(make_addr_expr(0, yypvt[-0].cptr, 0)));
		  i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (4, NULL, 0));
		  r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		} break;
case 107:
# line 1439 "parser.y"
{
		  i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (4, NULL, 0));
		  r_type_inst (Y_ADD_OP, 4, yypvt[-0].ival, 0);
		  r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		} break;
case 108:
# line 1446 "parser.y"
{
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (11, NULL, 0));
		      r_type_inst (Y_ADD_OP, 4, yypvt[-0].ival, 0);
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		} break;
case 109:
# line 1453 "parser.y"
{
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (1, NULL, 0));
		      r_type_inst (Y_ADD_OP, 4, yypvt[-0].ival, 0);
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		} break;
case 110:
# line 1460 "parser.y"
{
		  switch (get_label_type(yypvt[-1].cptr)) {
		    case BYTE_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (12, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    case WORD_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (5, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    case FLOAT_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (6, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    case DOUBLE_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (7, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    default:
		      yyerror ("Unknown type");
		  }
		  Store(yypvt[-1].cptr, yypvt[-0].ival);
		} break;
case 111:
# line 1485 "parser.y"
{
		  switch (get_label_type(yypvt[-1].cptr)) {
		    case BYTE_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (12, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    case WORD_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (12, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    case FLOAT_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (6, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    case DOUBLE_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (7, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    default:
		      yyerror ("Unknown type");
		  }
		  Store(yypvt[-1].cptr, yypvt[-0].ival);
		} break;
case 112:
# line 1510 "parser.y"
{
		  switch (get_label_type(yypvt[-1].cptr)) {
		    case BYTE_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (5, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    case WORD_A_TYPE:
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (5, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      break;
		    case FLOAT_A_TYPE:
		    case DOUBLE_A_TYPE:
		    default:
		      yyerror ("Unknown type");
		  }
		  Store(yypvt[-1].cptr, yypvt[-0].ival);
		} break;
case 113:
# line 1529 "parser.y"
{
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (12, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      r_type_inst (Y_ADD_OP, yypvt[-0].ival, 2, 0);
		      break;
		} break;
case 114:
# line 1537 "parser.y"
{
		      i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (5, NULL, 0));
		      r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		      r_type_inst (Y_ADD_OP, yypvt[-0].ival, 2, 0);
		      break;
		} break;
case 115:
# line 1545 "parser.y"
{
		  i_type_inst (Y_ORI_OP, 2, 0, make_imm_expr (10, NULL, 0));
		  r_type_inst (Y_SYSCALL_OP, 0, 0, 0);
		} break;
case 116:
# line 1551 "parser.y"
{
		  if ((yypvt[-1].ival != BYTE_A_TYPE) && (yypvt[-1].ival != WORD_A_TYPE))
		      yyerror("Type mismatch");
		  i_type_inst (yypvt[-2].ival, 0, A_SRC1_RNUM, yypvt[-0].ieptr);
		} break;
case 117:
# line 1559 "parser.y"
{
		  if ((yypvt[-1].ival != BYTE_A_TYPE) && (yypvt[-1].ival != WORD_A_TYPE))
		      yyerror("Type mismatch");
		  i_type_inst (yypvt[-2].ival == Y_BEQZ_POP ? Y_BEQ_OP : Y_BNE_OP,
			       0, A_SRC1_RNUM, yypvt[-0].ieptr);
		} break;
case 118:
# line 1568 "parser.y"
{
		  if (((yypvt[-2].ival != BYTE_A_TYPE) && (yypvt[-2].ival != WORD_A_TYPE)) ||
		      ((yypvt[-1].ival != BYTE_A_TYPE) && (yypvt[-1].ival != WORD_A_TYPE)))
		      yyerror("Type mismatch");
		  i_type_inst (yypvt[-3].ival, A_SRC1_RNUM, A_SRC2_RNUM, yypvt[-0].ieptr);
		} break;
case 119:
# line 1576 "parser.y"
{
		  if (((yypvt[-2].ival != BYTE_A_TYPE) && (yypvt[-2].ival != WORD_A_TYPE)) ||
		      ((yypvt[-1].ival != BYTE_A_TYPE) && (yypvt[-1].ival != WORD_A_TYPE)))
		      yyerror("Type mismatch");
		  r_type_inst (yypvt[-3].ival == Y_BGT_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, A_SRC2_RNUM, A_SRC1_RNUM); /* Use $at */
		  i_type_inst (Y_BNE_OP, 0, 1, yypvt[-0].ieptr);
		} break;
case 120:
# line 1586 "parser.y"
{
		  if (((yypvt[-2].ival != BYTE_A_TYPE) && (yypvt[-2].ival != WORD_A_TYPE)) ||
		      ((yypvt[-1].ival != BYTE_A_TYPE) && (yypvt[-1].ival != WORD_A_TYPE)))
		      yyerror("Type mismatch");
		  r_type_inst (yypvt[-3].ival == Y_BGE_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, A_SRC1_RNUM, A_SRC2_RNUM); /* Use $at */
		  i_type_inst (Y_BEQ_OP, 0, 1, yypvt[-0].ieptr);
		} break;
case 121:
# line 1596 "parser.y"
{
		  if (((yypvt[-2].ival != BYTE_A_TYPE) && (yypvt[-2].ival != WORD_A_TYPE)) ||
		      ((yypvt[-1].ival != BYTE_A_TYPE) && (yypvt[-1].ival != WORD_A_TYPE)))
		      yyerror("Type mismatch");
		  r_type_inst (yypvt[-3].ival == Y_BLT_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, A_SRC1_RNUM, A_SRC2_RNUM); /* Use $at */
		  i_type_inst (Y_BNE_OP, 0, 1, yypvt[-0].ieptr);
		} break;
case 122:
# line 1606 "parser.y"
{
		  if (((yypvt[-2].ival != BYTE_A_TYPE) && (yypvt[-2].ival != WORD_A_TYPE)) ||
		      ((yypvt[-1].ival != BYTE_A_TYPE) && (yypvt[-1].ival != WORD_A_TYPE)))
		      yyerror("Type mismatch");
		  r_type_inst (yypvt[-3].ival == Y_BLE_POP ? Y_SLT_OP : Y_SLTU_OP,
			       1, A_SRC2_RNUM, A_SRC1_RNUM); /* Use $at */
		  i_type_inst (Y_BEQ_OP, 0, 1, yypvt[-0].ieptr);
		} break;
case 124:
# line 1619 "parser.y"
{
		  i_type_inst (Y_ORI_OP, A_SRC1_RNUM, 0, 
			       make_imm_expr (yypvt[-0].ival, NULL, 0));
		  yyval.ival = WORD_A_TYPE;
		} break;
case 125:
# line 1626 "parser.y"
{
		  char *c = yypvt[-0].cptr;
		  if (strlen(c) > 1)
		    yyerror("illegal character constant");
		  i_type_inst (Y_ORI_OP, A_SRC1_RNUM, 0, make_imm_expr ((int)*c, NULL, 0));
		  yyval.ival = BYTE_A_TYPE;
		} break;
case 126:
# line 1635 "parser.y"
{
		  /* This does not handle doubles! */
		  float x = *yypvt[-0].dptr;
		  int *y = (int *) &x;

		  i_type_inst (Y_ORI_OP, 1, 0, const_imm_expr (*y));
		  r_type_inst (Y_MTC1_OP, AF_SRC1_RNUM, 0, 1);
		  yyval.ival = FLOAT_A_TYPE;
		} break;
case 127:
# line 1646 "parser.y"
{
		  if (yypvt[-0].ival == 0) {
		      yyval.ival = get_label_type(yypvt[-1].cptr);
		  } else if (0 == strcmp(yypvt[-1].cptr, "M")) {
		      yyval.ival = WORD_A_TYPE;
		      yypvt[-1].cptr = NULL;
		  } else if (0 == strcmp (yypvt[-1].cptr, "m")) {
		      yyval.ival = BYTE_A_TYPE;
		      yypvt[-1].cptr = NULL;
		  } else {
		      yyval.ival = BYTE_A_TYPE;
		      yyerror("Bad array, use M or m.\n");
		  }
		  switch (yyval.ival) {
		    case WORD_A_TYPE:
		      /*
		      if ($2 != 0)
			  r_sh_type_inst (Y_SLL_OP, $2, $2, 2);
		      */
		      i_type_inst (Y_LW_OP, A_SRC1_RNUM, yypvt[-0].ival, 
			   addr_expr_imm(make_addr_expr(0, yypvt[-1].cptr, 0)));
		      break;
		    case BYTE_A_TYPE:
		      i_type_inst (Y_LB_OP, A_SRC1_RNUM, yypvt[-0].ival, 
			   addr_expr_imm(make_addr_expr(0, yypvt[-1].cptr, 0)));
		      break;
		    case FLOAT_A_TYPE:
		      /*
		      if ($2 != 0)
			  r_sh_type_inst (Y_SLL_OP, $2, $2, 2);
		      */
		      i_type_inst (Y_LWC1_OP, AF_SRC1_RNUM, yypvt[-0].ival, 
			   addr_expr_imm(make_addr_expr(0, yypvt[-1].cptr, 0)));
		      break;
		    case DOUBLE_A_TYPE:
		      /*
		      if ($2 != 0)
			  r_sh_type_inst (Y_SLL_OP, $2, $2, 3);
		      */
		      i_type_inst (Y_LWC1_OP, AF_SRC1_RNUM, yypvt[-0].ival, 
			   addr_expr_imm(make_addr_expr(0, yypvt[-1].cptr, 0)));
		      i_type_inst (Y_LWC1_OP, AF_SRC1_RNUM + 1, yypvt[-0].ival,
			incr_expr_offset(addr_expr_imm(
				make_addr_expr(0, yypvt[-1].cptr, 0)), 4));
		      break;
		    default:
		      yyerror ("Unknown type");
		  }
		} break;
case 128:
# line 1698 "parser.y"
{
		  i_type_inst (Y_ORI_OP, A_SRC2_RNUM, 0, 
			       make_imm_expr (yypvt[-0].ival, NULL, 0));
		  yyval.ival = WORD_A_TYPE;
		} break;
case 129:
# line 1705 "parser.y"
{
		  char *c = yypvt[-0].cptr;
		  if (strlen(c) > 1)
		    yyerror("illegal character constant");
		  i_type_inst (Y_ORI_OP, A_SRC2_RNUM, 0, make_imm_expr ((int)*c, NULL, 0));
		  yyval.ival = BYTE_A_TYPE;
		} break;
case 130:
# line 1714 "parser.y"
{
		  /* This does not handle doubles! */
		  float x = *yypvt[-0].dptr;
		  int *y = (int *) &x;

		  i_type_inst (Y_ORI_OP, 1, 0, const_imm_expr (*y));
		  r_type_inst (Y_MTC1_OP, AF_SRC2_RNUM, 0, 1);
		  yyval.ival = FLOAT_A_TYPE;
		} break;
case 131:
# line 1725 "parser.y"
{
		  if (yypvt[-0].ival == 0) {
		      yyval.ival = get_label_type(yypvt[-1].cptr);
		  } else if (0 == strcmp(yypvt[-1].cptr, "M")) {
		      yyval.ival = WORD_A_TYPE;
		      yypvt[-1].cptr = NULL;
		  } else if (0 == strcmp (yypvt[-1].cptr, "m")) {
		      yyval.ival = BYTE_A_TYPE;
		      yypvt[-1].cptr = NULL;
		  } else {
		      yyval.ival = BYTE_A_TYPE;
		      yyerror("Bad array, use M or m.\n");
		  }
		  switch (yyval.ival) {
		    case WORD_A_TYPE:
		      /*
		      if ($2 != 0)
			  r_sh_type_inst (Y_SLL_OP, $2, $2, 2);
		      */
		      i_type_inst (Y_LW_OP, A_SRC2_RNUM, yypvt[-0].ival, 
			   addr_expr_imm(make_addr_expr(0, yypvt[-1].cptr, 0)));
		      break;
		    case BYTE_A_TYPE:
		      i_type_inst (Y_LB_OP, A_SRC2_RNUM, yypvt[-0].ival, 
			   addr_expr_imm(make_addr_expr(0, yypvt[-1].cptr, 0)));
		      break;
		    case FLOAT_A_TYPE:
		      /*
		      if ($2 != 0)
			  r_sh_type_inst (Y_SLL_OP, $2, $2, 2);
		      */
		      i_type_inst (Y_LWC1_OP, AF_SRC2_RNUM, yypvt[-0].ival, 
			   addr_expr_imm(make_addr_expr(0, yypvt[-1].cptr, 0)));
		      break;
		    case DOUBLE_A_TYPE:
		      /*
		      if ($2 != 0)
			  r_sh_type_inst (Y_SLL_OP, $2, $2, 3);
		      */
		      i_type_inst (Y_LWC1_OP, AF_SRC2_RNUM, yypvt[-0].ival, 
			   addr_expr_imm(make_addr_expr(0, yypvt[-1].cptr, 0)));
		      i_type_inst (Y_LWC1_OP, AF_SRC2_RNUM + 1, yypvt[-0].ival,
			incr_expr_offset(addr_expr_imm(
				make_addr_expr(0, yypvt[-1].cptr, 0)), 4));
		      break;
		    default:
		      yyerror ("Unknown type");
		  }
		} break;
case 132:
# line 1777 "parser.y"
{ yyval.ival = 0; } break;
case 133:
# line 1779 "parser.y"
{ 
		  i_type_inst (Y_ORI_OP, A_DSUB_RNUM, 0, 
			       make_imm_expr (yypvt[-1].ival, NULL, 0));
		  yyval.ival = A_DSUB_RNUM;
		} break;
case 134:
# line 1786 "parser.y"
{
		  char *c = yypvt[-1].cptr;
		  if (strlen(c) > 1)
		    yyerror("illegal character constant");
		  i_type_inst (Y_ORI_OP, A_DSUB_RNUM, 0, 
			       make_imm_expr ((int)*c, NULL, 0));
		  yyval.ival = A_DSUB_RNUM;
		} break;
case 135:
# line 1796 "parser.y"
{
		  switch (get_label_type(yypvt[-1].cptr)) {
		    case WORD_A_TYPE:
		      i_type_inst (Y_LW_OP, A_DSUB_RNUM, 0, 
			   addr_expr_imm(make_addr_expr(0, yypvt[-1].cptr, 0)));
		      break;
		    case BYTE_A_TYPE:
		      i_type_inst (Y_LB_OP, A_DSUB_RNUM, 0, 
			   addr_expr_imm(make_addr_expr(0, yypvt[-1].cptr, 0)));
		      break;
		    case FLOAT_A_TYPE:
		    case DOUBLE_A_TYPE:
		    default:
		      yyerror ("Bad array index.");
		  }
		  yyval.ival = A_DSUB_RNUM;
		} break;
case 136:
# line 1815 "parser.y"
{ yyval.ival = 0; } break;
case 137:
# line 1817 "parser.y"
{ 
		  i_type_inst (Y_ORI_OP, A_SUB_RNUM, 0, 
			       make_imm_expr (yypvt[-1].ival, NULL, 0));
		  yyval.ival = A_SUB_RNUM;
		} break;
case 138:
# line 1824 "parser.y"
{
		  char *c = yypvt[-1].cptr;
		  if (strlen(c) > 1)
		    yyerror("illegal character constant");
		  i_type_inst (Y_ORI_OP, A_SUB_RNUM, 0, 
			       make_imm_expr ((int)*c, NULL, 0));
		  yyval.ival = A_SUB_RNUM;
		} break;
case 139:
# line 1834 "parser.y"
{
		  switch (get_label_type(yypvt[-1].cptr)) {
		    case WORD_A_TYPE:
		      i_type_inst (Y_LW_OP, A_SUB_RNUM, 0, 
			  addr_expr_imm(make_addr_expr(0, yypvt[-1].cptr, 0)));
		      break;
		    case BYTE_A_TYPE:
		      i_type_inst (Y_LB_OP, A_SUB_RNUM, 0, 
			   addr_expr_imm(make_addr_expr(0, yypvt[-1].cptr, 0)));
		      break;
		    case FLOAT_A_TYPE:
		    case DOUBLE_A_TYPE:
		    default:
		      yyerror ("Bad array index.");
		  }
		  yyval.ival = A_SUB_RNUM;
		} break;
case 314:
# line 2119 "parser.y"
{
		  align_data (yypvt[-0].ival);
		} break;
case 315:
# line 2123 "parser.y"
{null_term = 0;} break;
case 316:
# line 2124 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment\n");
		} break;
case 317:
# line 2129 "parser.y"
{null_term = 1;} break;
case 318:
# line 2130 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment\n");
		} break;
case 321:
# line 2141 "parser.y"
{store_op = store_byte;} break;
case 322:
# line 2142 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment\n");
		  if (abstract_line_label)
		     set_label_type(abstract_line_label, BYTE_A_TYPE);
		} break;
case 323:
# line 2151 "parser.y"
{
		  align_data (2);
		  if (lookup_label (yypvt[-1].cptr)->addr == 0)
		    record_label (yypvt[-1].cptr,current_data_pc ());
		  increment_data_pc (yypvt[-0].ival);
		} break;
case 324:
# line 2160 "parser.y"
{
		  user_kernel_data_segment (0);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 325:
# line 2167 "parser.y"
{
		  user_kernel_data_segment (1);
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 326:
# line 2173 "parser.y"
{store_op = store_double;} break;
case 327:
# line 2174 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment\n");
		  if (abstract_line_label)
		    set_label_type(abstract_line_label, DOUBLE_A_TYPE);
		} break;
case 333:
# line 2193 "parser.y"
{
		  extern_directive (yypvt[-1].cptr, yypvt[-0].ival);
		} break;
case 334:
# line 2199 "parser.y"
{
		     record_label (yypvt[-1].cptr, yypvt[-0].ival);
		} break;
case 335:
# line 2204 "parser.y"
{
		  fatal_error ("File contains an .err directive\n");
		} break;
case 337:
# line 2212 "parser.y"
{store_op = store_float;} break;
case 338:
# line 2213 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment\n");
		  if (abstract_line_label)
		    set_label_type(abstract_line_label, FLOAT_A_TYPE);
		} break;
case 341:
# line 2227 "parser.y"
{
		  make_label_global (yypvt[-0].cptr);
		} break;
case 342:
# line 2232 "parser.y"
{store_op = store_half;} break;
case 343:
# line 2233 "parser.y"
{
		  if (text_dir)
		    yyerror ("Can't put data in text segment\n");
		} break;
case 344:
# line 2240 "parser.y"
{
		  record_label (yypvt[-0].cptr, (text_dir ? current_text_pc ()
				     : current_data_pc ()));
		} break;
case 345:
# line 2247 "parser.y"
{
		  lcomm_directive (yypvt[-1].cptr, yypvt[-0].ival);
		} break;
case 351:
# line 2265 "parser.y"
{
		  yyerror ("Warning: repeat directive ignored\n");
		} break;
case 352:
# line 2271 "parser.y"
{
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 353:
# line 2278 "parser.y"
{
		  data_dir = 1; text_dir = 0;
		  enable_data_alignment ();
		} break;
case 354:
# line 2285 "parser.y"
{
		  if (streq (yypvt[-0].cptr, "noat"))
		    noat_flag = 1;
		  else if (streq (yypvt[-0].cptr, "at"))
		    noat_flag = 0;
		} break;
case 355:
# line 2294 "parser.y"
{
		  if (data_dir)
		    increment_data_pc (yypvt[-0].ival);
		  else if (text_dir)
		    increment_text_pc (yypvt[-0].ival);
		} break;
case 356:
# line 2303 "parser.y"
{
		  yyerror ("Warning: struct directive ignored\n");
		} break;
case 357:
# line 2309 "parser.y"
{
		  user_kernel_text_segment (0);
		  data_dir = 0; text_dir = 1;
		  enable_data_alignment ();
		} break;
case 358:
# line 2317 "parser.y"
{
		  user_kernel_text_segment (1);
		  data_dir = 0; text_dir = 1;
		  enable_data_alignment ();
		} break;
case 361:
# line 2330 "parser.y"
{
		  store_op = store_word_data;
		  if (abstract_line_label)
		    set_label_type(abstract_line_label, WORD_A_TYPE);
		} break;
case 363:
# line 2340 "parser.y"
{
		  yyval.aeptr = make_addr_expr (0, NULL, yypvt[-1].ival);
		} break;
case 364:
# line 2345 "parser.y"
{
		  yyval.aeptr = make_addr_expr (yypvt[-0].ival, NULL, 0);
		} break;
case 365:
# line 2350 "parser.y"
{
		  yyval.aeptr = make_addr_expr (yypvt[-3].ival, NULL, yypvt[-1].ival);
		} break;
case 366:
# line 2355 "parser.y"
{
		  yyval.aeptr = make_addr_expr (0, yypvt[-0].cptr, 0);
		} break;
case 367:
# line 2360 "parser.y"
{
		  yyval.aeptr = make_addr_expr (0, yypvt[-3].cptr, yypvt[-1].ival);
		} break;
case 368:
# line 2365 "parser.y"
{
		  yyval.aeptr = make_addr_expr (yypvt[-0].ival, yypvt[-2].cptr, 0);
		} break;
case 369:
# line 2370 "parser.y"
{
		  yyval.aeptr = make_addr_expr (yypvt[-2].ival, yypvt[-0].cptr, 0);
		} break;
case 370:
# line 2375 "parser.y"
{
		  yyval.aeptr = make_addr_expr (- yypvt[-0].ival, yypvt[-2].cptr, 0);
		} break;
case 371:
# line 2380 "parser.y"
{
		  yyval.aeptr = make_addr_expr (yypvt[-3].ival, yypvt[-5].cptr, yypvt[-1].ival);
		} break;
case 372:
# line 2385 "parser.y"
{
		  yyval.aeptr = make_addr_expr (- yypvt[-3].ival, yypvt[-5].cptr, yypvt[-1].ival);
		} break;
case 373:
# line 2390 "parser.y"
{
		  yyerror("Address expected");
		  yyval.aeptr = make_addr_expr (0, "not defined!", 0);
		} break;
case 374:
# line 2398 "parser.y"
{
		  yyval.ieptr = make_imm_expr (yypvt[-0].ival, NULL, 0);
		} break;
case 375:
# line 2403 "parser.y"
{
		  char *c = yypvt[-0].cptr;
		  if (strlen(c) > 1)
		    yyerror("illegal character constant");
		  yyval.ieptr = make_imm_expr ((int)*c, NULL, 0);
		} break;
case 376:
# line 2411 "parser.y"
{
		  yyval.ieptr = make_imm_expr (0, yypvt[-0].cptr, 0);
		} break;
case 377:
# line 2416 "parser.y"
{
		  yyval.ieptr = make_imm_expr (yypvt[-0].ival, yypvt[-2].cptr, 0);
		} break;
case 378:
# line 2421 "parser.y"
{
		  yyval.ieptr = make_imm_expr (- yypvt[-0].ival, yypvt[-2].cptr, 0);
		} break;
case 386:
# line 2442 "parser.y"
{
		  if (yypvt[-0].ival < 0 || yypvt[-0].ival > 31)
		    yyerror ("Register number out of range");
		  if (yypvt[-0].ival == 1 && !bare_machine && !noat_flag)
		    yyerror ("Register 1 is reserved for assembler");
		  yyval.ival = yypvt[-0].ival;
		} break;
case 390:
# line 2458 "parser.y"
{
		  if (yypvt[-0].ival < 0 || yypvt[-0].ival > 31)
		    yyerror ("FP register number out of range");
		  yyval.ival = yypvt[-0].ival;
		} break;
case 391:
# line 2465 "parser.y"
{
		  yyerror("Floating point register required");
		  yyval.ival = 0;
		} break;
case 394:
# line 2480 "parser.y"
{
		  yyval.ieptr = make_imm_expr (- current_text_pc (), yypvt[-0].cptr, 1);
		} break;
case 395:
# line 2485 "parser.y"
{
		  yyval.ieptr = make_imm_expr (0, "Not defined!", 0);
		  yyerror("Label required");
		} break;
case 396:
# line 2493 "parser.y"
{
		  store_string (yypvt[-0].cptr, y_str_length, null_term);
		} break;
case 397:
# line 2497 "parser.y"
{
		  store_string (yypvt[-0].cptr, y_str_length, null_term);
		} break;
case 398:
# line 2502 "parser.y"
{
		  yyerror("String expected");
		} break;
case 400:
# line 2511 "parser.y"
{
	      char *c = yypvt[-0].cptr;
	      if (strlen(c) > 1)
		yyerror("illegal character constant");
	      yyval.ival = (int)*c;
	    } break;
case 401:
# line 2519 "parser.y"
{
		  label *l = lookup_label (yypvt[-0].cptr);

		  if (l->addr == NULL)
		    {
		      if (store_op == store_double) align_data(3);
		      if (store_op == store_float) align_data(2);
		      if (store_op == store_word_data) align_data(2);
		      if (store_op == store_half) align_data(1);
		      record_data_uses_symbol (current_data_pc (), l);
		      yyval.ival = 0;
		    }
		  else
		    yyval.ival = l->addr;
		} break;
case 402:
# line 2536 "parser.y"
{
		  yyval.ival = 0;
		  yyerror("Expression expected");
		} break;
case 404:
# line 2545 "parser.y"
{
		  store_op(0);
		} break;
case 405:
# line 2551 "parser.y"
{
		  store_op (yypvt[-0].ival);
		} break;
case 406:
# line 2555 "parser.y"
{
		  store_op (yypvt[-0].ival);
		} break;
case 407:
# line 2559 "parser.y"
{
		  int i;

		  for (i = 0; i < yypvt[-0].ival; i ++)
		    store_op (yypvt[-2].ival);
		} break;
case 409:
# line 2570 "parser.y"
{
		  double z = 0;
		  store_op(&z);
		} break;
case 410:
# line 2577 "parser.y"
{
		  store_op (yypvt[-0].dptr);
		} break;
case 411:
# line 2581 "parser.y"
{
		  store_op (yypvt[-0].dptr);
		} break;
case 413:
# line 2588 "parser.y"
{yyval.cptr = NULL;} break; 
		}
		goto yystack;  /* stack new state and value */

	}
