/* SPIM S20 MIPS simulator.
   Definitions for the SPIM S20.
   Copyright (C) 1990 by James Larus (larus@cs.wisc.edu).

   SPIM is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 1, or (at your option) any
   later version.

   SPIM is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GNU CC; see the file COPYING.  If not, write to James R.
   Larus, Computer Sciences Department, University of Wisconsin--Madison,
   1210 West Dayton Street, Madison, WI 53706, USA or to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */


/* $Header: /u/scottk/cs354/spim/RCS/spim.h,v 2.22 1992/12/06 22:20:32 scottk Exp $
*/


/* My apologies for all the ifdefs and ifndefs.
   It seems that on many systems stddef.h defines
   size_t one way and sys/types.h another.
   Worse yet, some systems include sys/types.h
   from Xlib.h even if stddef.h has already been
   included.  Also, lex has its own way of dealing
   with this mess and that can conflict with
   stuff too.  */

#ifndef WIN32
#ifndef __GNUC__
#define const		/* Ignore constants for most compilers */
#else
#ifndef __STDC__
#define const
#endif /* GNUC */
#endif /* STDC */
#endif /* WIN32 */

#ifndef YY_NULL
#ifdef __STDC__
#ifdef __GNUC__
/* #include <stddef.h>	Can't include this. It clashes with X windows. */
void *malloc( );
void free( void* );
#else
#include <stdlib.h>
#endif /* __GNUC__ */
#else /* if !__STDC__ */
char *malloc();
int free();
#endif/* __STDC__ */
#endif /* YY_NULL */


#include <math.h>
#include <string.h>

#ifndef _STDDEF_H		/* stddef.h can conflict with sys/types */
#include <sys/types.h>			/* Lex wants to use stddef.h too */
#endif


#define streq(s1, s2) (!strcmp(s1, s2))

/* Round V to next greatest B boundary */

#define ROUND(V, B) (((int) V + (B-1)) & ~(B-1))


/* Sign-extend a short to a long */

#define SIGN_EX(X)	((X) & 0x8000 ? (X) | 0xffff0000 : (X))


#define K 1024

/* Triple containing a string and two integers.	 Used in tables
   mapping from a name to values. */

typedef struct strint
{
  char *name;
  int value1;
  int value2;
} inst_info;

/* Type of a memory address. */

typedef unsigned long mem_addr;

/* Useful and pervasive declarations: */

#ifdef WIN32
#include <memory.h>
#define bcopy(src,dest,n) memcpy(dest,src,n)
#define bcmp(p1,p2,n) memcmp(p1,p2,n)
#define bzero(p, n) memset(p, 0, n)
void *malloc ();
#else
void bzero (void *, size_t);
void bcopy (const void *, void *, size_t);
int bcmp(const void *, const void *, size_t);
#endif
void write_output (long, char *);
void read_input(char *, int);
void initialize_world(int);
void initialize_registers(void );
int read_assembly_file(char *);
unsigned long starting_address(void );
void initialize_run_stack(int argc,char **argv );
int run_program(unsigned long pc,int steps,int display,int cont_bkpt);

/* spim-utils.h */

void add_breakpoint(unsigned long addr);
void delete_breakpoint(unsigned long addr);
void fatal_error(char *);
void list_breakpoints(void );
int run_error (char *);
void error (char *);
inst_info *map_string_to_inst_info(inst_info tbl[],int tbl_len,
    const register char *id);
inst_info *map_int_to_inst_info(inst_info tbl[],int tbl_len,
    register int num);

/* spim.c or xspim.c */
void PollInput();

/* scanner */

void intialize_scanner(FILE *);
void print_erroneous_line (void);
void scanner_start_line (void);
int register_name_to_number (const char *);
int yylex(void);

/* parser */

void fix_current_label_address (mem_addr);
struct immexpr *branch_offset (int);
int op_to_imm_op (int);
int imm_op_to_op (int);
void yyerror (const char *);

/* Variables: */

extern int bare_machine;	/* Simulate bare instruction set */
extern int quiet;		/* No warning messages */
extern int memio;		/* Use memory mapped I/O */
extern int source_file;		/* Program is source, not binary */
extern int console_uses_stdin;	/* Set to 1 from spim and 0 for xspim */
extern char mess_buff[];


/* Real type depends on X/terminal interface */
extern int message_out, console_out, terminal_out;



#define BYTES_PER_WORD 4	/* On the MIPS processor */


/* Sizes of memory segments. */

/* Initial size of text segment. */

#ifndef TEXT_SIZE
#define TEXT_SIZE	64*K	/* 64 KB */
#endif

/* Initial size of k_text segment. */

#ifndef K_TEXT_SIZE
#define K_TEXT_SIZE	64*K	/* 64 KB */
#endif

/* The data segment must be larger than 64K since we immediate grab
   64K for the small data segment pointed to by $gp. The data segment is
   expanded by an sbrk system call. */

/* Initial size of data segment. */

#ifndef DATA_SIZE
#define DATA_SIZE	128*K	/* 128 KB */
#endif

/* Maximum size of data segment. */

#ifndef DATA_LIMIT
#define DATA_LIMIT	1000*K	/* 1 MB */
#endif

/* Initial size of k_data segment. */

#ifndef K_DATA_SIZE
#define K_DATA_SIZE	64*K	/* 64 KB */
#endif

/* Maximum size of k_data segment. */

#ifndef K_DATA_LIMIT
#define K_DATA_LIMIT	1000*K	/* 1 MB */
#endif


/* The stack grows down automatically. */

/* Initial size of stack segment. */

#ifndef STACK_SIZE
#define STACK_SIZE	64*K	/* 64 KB */
#endif

/* Maximum size of stack segment. */

#ifndef STACK_LIMIT
#define STACK_LIMIT	256*K	/* 1 MB */
#endif


/* Name of the function to invoke at start up */

#define DEFAULT_RUN_LOCATION "__start"


/* Default number of instructions to execute. */

#define DEFAULT_RUN_STEPS 2147483647


/* Address to branch to when exception occurs */

#define EXCEPTION_ADDR 0x80000080


/* Maximum size of object stored in the small data segment pointed to by
   $gp */

#define SMALL_DATA_SEG_MAX_SIZE 8



/* Argument passing registers */

#define REG_V0 2
#define REG_A0 4
#define REG_A1 5
#define REG_A2 6
#define REG_A3 7
#define REG_FA0 12


/* Result registers */

#define REG_RES 2
#define REG_FRES 0


/* $gp registers */

#define REG_GP 28


