/* SPIM S20 MIPS simulator.
   Declarations of registers and code for accessing them.
   Copyright (C) 1990 by James Larus (larus@cs.wisc.edu).

   SPIM is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 1, or (at your option) any
   later version.

   SPIM is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GNU CC; see the file COPYING.  If not, write to James R.
   Larus, Computer Sciences Department, University of Wisconsin--Madison,
   1210 West Dayton Street, Madison, WI 53706, USA or to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */


/* $Header: /u/scottk/cs354/spim/RCS/reg.h,v 2.1 1992/11/14 18:31:45 scottk Exp $
*/



typedef long reg_word;


/* General purpose registers: */

reg_word R[32];

reg_word HI, LO;

mem_addr PC;



/* Floating Point Coprocessor (1) registers :*/

double *FPR;			/* Dynamically allocate so overlay */
float *FGR;			/* is possible */
int *FWR;			/* is possible */


#define FPR_S(REGNO) (((REGNO) & 0x1) \
		      ? (run_error ("Bit 0 in FP reg spec\n") ? 0.0 : 0.0)\
		      : FGR[REGNO])

#define FPR_D(REGNO) (double) (((REGNO) & 0x1) \
			       ? (run_error ("Bit 0 in FP reg spec\n") ? 0.0 : 0.0)\
			       : FPR[(REGNO) >> 1])

#define FPR_W(REGNO) (((REGNO) & 0x1) \
		      ? (run_error ("Bit 0 in FP reg spec\n") ? 0 : 0)\
		      : FWR[REGNO])


#define SET_FPR_S(REGNO, VALUE) {if ((REGNO) & 0x1) \
				 run_error ("Bit 0 in FP reg spec\n");\
				 else FGR[REGNO] = (double) (VALUE);}

#define SET_FPR_D(REGNO, VALUE) {if ((REGNO) & 0x1) \
				 run_error ("Bit 0 in FP reg spec\n");\
				 else FPR[(REGNO) >> 1] = (double) (VALUE);}

#define SET_FPR_W(REGNO, VALUE) {if ((REGNO) & 0x1) \
				 run_error ("Bit 0 in FP reg spec\n");\
				 else FWR[REGNO] = (int) (VALUE);}


/* Other Coprocessor Registers The floating point registers
   (coprocessor 1) are allocated elsewhere.  */

reg_word CpCond[4], CCR[4][32], CPR[4][32];


/* Exeception Handling Registers (actually registers in Coprocoessor
   0's register file) */

int exception_occurred;

#define Context		(CPR[0][4])
#define BadVAddr	(CPR[0][8])
#define Status_Reg	(CPR[0][12])
#define Cause		(CPR[0][13])
#define EPC		(CPR[0][14])
#define PRId		(CPR[0][15])


/* Floating point control and condition registers: */

#define FCR		CPR[1]
#define FPId		(CPR[1][0])
#define FpCond		(CPR[1][31])


