/* SPIM S20 MIPS simulator.
   Definitions of MIPS system calls
   Copyright (C) 1990 by James Larus (larus@cs.wisc.edu).

   SPIM is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 1, or (at your option) any
   later version.

   SPIM is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GNU CC; see the file COPYING.  If not, write to James R.
   Larus, Computer Sciences Department, University of Wisconsin--Madison,
   1210 West Dayton Street, Madison, WI 53706, USA or to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: /u/scottk/cs354/spim/RCS/mips-syscall.h,v 2.0 1992/11/03 23:22:03 scottk Exp $
*/


/* Description of (most) MIPS system calls so SPIM can pass the correct
   arguments to the system when a user program executes a syscall in
   binary mode. */

typedef struct
{
  int syscall_num;
  int syscall_type;
  int arg0;
  int arg1;
  int arg2;
  int arg3;
} syscall_desc;


/* Way in which system calls are handled by SPIM. */

#define BAD_SYSCALL	0
#define UNIX_SYSCALL	1
#define SPC_SYSCALL	2	/* handled SPCly in SPIM */


/* Type of argument (ie translation necessary before passing to system). */

#define NO_ARG 0
#define INT_ARG	1
#define ADDR_ARG 2


syscall_desc syscall_table[] =
{
  {SYS_syscall,	UNIX_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_exit, 	SPC_SYSCALL,	INT_ARG,  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_fork, 	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_read,	UNIX_SYSCALL,	INT_ARG,  ADDR_ARG, INT_ARG,  NO_ARG,},
  {SYS_write,	UNIX_SYSCALL,	INT_ARG,  ADDR_ARG, INT_ARG,  NO_ARG,},
  {SYS_open,	UNIX_SYSCALL,	ADDR_ARG, INT_ARG,  INT_ARG,  NO_ARG,},
  {SYS_close,	UNIX_SYSCALL,	INT_ARG,  NO_ARG,   NO_ARG,   NO_ARG,},
  {/* wait */ 7, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_creat,	UNIX_SYSCALL,	ADDR_ARG, INT_ARG,  NO_ARG,   NO_ARG,},
  {SYS_link,	UNIX_SYSCALL,	ADDR_ARG, ADDR_ARG, NO_ARG,   NO_ARG,},
  {SYS_unlink,	UNIX_SYSCALL,	ADDR_ARG, NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_execv, 	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_chdir,	UNIX_SYSCALL,	ADDR_ARG, NO_ARG,   NO_ARG,   NO_ARG,},
  {13,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_mknod,	UNIX_SYSCALL,	ADDR_ARG, INT_ARG,  INT_ARG,  NO_ARG,},
  {SYS_chmod,	UNIX_SYSCALL,	ADDR_ARG, INT_ARG,  NO_ARG,   NO_ARG,},
  {SYS_chown,	UNIX_SYSCALL,	ADDR_ARG, INT_ARG,  INT_ARG,  NO_ARG,},
  {SYS_brk,	SPC_SYSCALL,	ADDR_ARG, NO_ARG,   NO_ARG,   NO_ARG,},
  {18,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_lseek,	UNIX_SYSCALL,	INT_ARG,  INT_ARG,  INT_ARG,  NO_ARG,},
  {SYS_getpid,	UNIX_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_mount,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_umount,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {23,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_getuid,	UNIX_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {25,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_ptrace,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {27,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {28,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {29,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {30,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {31,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {32,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_access,	UNIX_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {34,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {35,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_sync,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_kill,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_stat,	UNIX_SYSCALL,	ADDR_ARG, ADDR_ARG, NO_ARG,   NO_ARG,},
  {39,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_lstat,	UNIX_SYSCALL,	ADDR_ARG, ADDR_ARG, NO_ARG,   NO_ARG,},
  {SYS_dup,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_pipe,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {43,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_profil,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {45,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {46,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_getgid,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {48,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {49,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {50,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_acct,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {52,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {53,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_ioctl,	UNIX_SYSCALL,	INT_ARG,  INT_ARG,  ADDR_ARG, NO_ARG,},
  {SYS_reboot,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {56,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_symlink,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_readlink, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_execve,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_umask,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_chroot,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_fstat,	UNIX_SYSCALL,	INT_ARG,  ADDR_ARG, NO_ARG,   NO_ARG,},
  {63,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_getpagesize,UNIX_SYSCALL,NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_mremap,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_vfork,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {67,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {68,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_sbrk,	UNIX_SYSCALL,	INT_ARG,  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_sstk,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_mmap,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_vadvise,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_munmap,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_mprotect, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_madvise,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_vhangup,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {77,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_mincore,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_getgroups, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_setgroups, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_getpgrp,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_setpgrp,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_setitimer, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_wait3,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_swapon,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_getitimer, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_gethostname, BAD_SYSCALL,NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_sethostname, BAD_SYSCALL,NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_getdtablesize, UNIX_SYSCALL,NO_ARG,NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_dup2,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_getdopt,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_fcntl,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_select,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_setdopt,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_fsync,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_setpriority, BAD_SYSCALL,NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_socket,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_connect,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_accept,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_getpriority, BAD_SYSCALL,NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_send,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_recv,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_sigreturn, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_bind,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_setsockopt, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_listen,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {107,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_sigvec,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_sigblock, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_sigsetmask, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_sigpause, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_sigstack, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_recvmsg,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_sendmsg,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {115,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_gettimeofday, BAD_SYSCALL,NO_ARG,  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_getrusage, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_getsockopt, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {119,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_readv,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_writev,	UNIX_SYSCALL,	INT_ARG,  ADDR_ARG, INT_ARG,  NO_ARG,},
  {SYS_settimeofday, BAD_SYSCALL,NO_ARG,  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_fchown,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_fchmod,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_recvfrom, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_setreuid, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_setregid, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_rename,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_truncate, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_ftruncate, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_flock,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {132,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_sendto,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_shutdown, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_socketpair, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_mkdir,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_rmdir,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_utimes,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_sigcleanup, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_adjtime,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_getpeername, BAD_SYSCALL,NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_gethostid, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_sethostid, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_getrlimit, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_setrlimit, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_killpg,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {147,		BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_setquota, BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_quota,	BAD_SYSCALL,	NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
  {SYS_getsockname, BAD_SYSCALL,NO_ARG,	  NO_ARG,   NO_ARG,   NO_ARG,},
};

#define MAX_SYSCALL	150

#define SYSCALL_ARG(ARG, REG)						\
  (syscall_table [R[REG_V0]].ARG == ADDR_ARG? MEM_ADDRESS(R[REG]) : R[REG])
