# SPIM S20 MIPS simulator.
# A test of SAL on the Spim simulator.
# Copyright (C) 1992 Scott Kempf, socttk@cs.wisc.edu
#
# SPIM is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 1, or (at your option) any
# later version.
#
# SPIM is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU CC; see the file COPYING.
#
	.ktext			# Catch exeption.
	.space 0x80
	beq	$k1 $0 expected
	la	$k1 fail
	rfe
	j	$k1

expected:
	mfc0	$k0 $13
	and	$k0 $k0 0xff
	sra	$k0 $k0 2	# $k0 holds ExcCode
	bne	$k0 $0 not_interrupt

	mfc0	$k1 $13
	and	$k1 $k1 0xfffffcff	# Clear software interrupts.
	mtc0	$k1 $13
	mfc0	$k1 $14
	sub	$k1 $k1 4	# Sutract 4, since interrupts
	mtc0	$k1 $14		# happend a the beging of a cycle

not_interrupt:
	mfc0	$k1 $14
	.data
fmess:	.asciiz "Test failed\n"
	.text
fail:	puts fmess
	done

	.data
m1:	.asciiz "Testing branches\n"
one:	.word	1
_one:	.word	-1
two:	.word	2
_two:	.word	-2
	.text
__start:puts m1

	.data
m2:	.asciiz "\tTesting beq\n"
	.text
	puts	m2
	beq	1, 2, fail
	beq	-1, 1, fail
	beq	one, two, fail
	beq	_one, one, fail
	beq	1, 1, ok2_1
ok2_1:	beq	-1, -1, ok2_2
	j	fail
ok2_2:	beq	one, one, ok2_3
	j	fail
ok2_3:	beq	_one, _one, ok2_4
	j	fail
ok2_4:

	.data
m3:	.asciiz "\tTesting bne\n"
	.text
	puts	m3
	bne	1, 1, fail
	bne	-1, -1, fail
	bne	one, one, fail
	bne	_one, _one, fail
	bne	1, 2, ok3_1
	j	fail
ok3_1:	bne	-1, 1, ok3_2
	j	fail
ok3_2:	bne	one, two, ok3_3
	j	fail
ok3_3:	bne	_one, one, ok3_4
	j	fail
ok3_4:

	.data
m4:	.asciiz "\tTesting blt\n"
	.text
	puts	m4
	blt	1, 1, fail
	blt	-1, -1, fail
	blt	one, one, fail
	blt	_one, _one, fail
	blt	2, 1, fail
	blt	1, -1, fail
	blt	two, one, fail
	blt	one, _one, fail
	blt	1, 2, ok4_1
	j	fail
ok4_1:	blt	-1, 1, ok4_2
	j	fail
ok4_2:	blt	one, two, ok4_3
	j	fail
ok4_3:	blt	_one, one, ok4_4
	j	fail
ok4_4:

	.data
m5:	.asciiz "\tTesting bgt\n"
	.text
	puts	m5
	bgt	1, 1, fail
	bgt	-1, -1, fail
	bgt	one, one, fail
	bgt	_one, _one, fail
	bgt	1, 2, fail
	bgt	-1, 1, fail
	bgt	one, two, fail
	bgt	_one, one, fail
	bgt	2, 1, ok5_1
	j	fail
ok5_1:	bgt	1, -1, ok5_2
	j	fail
ok5_2:	bgt	two, one, ok5_3
	j	fail
ok5_3:	bgt	one, _one, ok5_4
	j	fail
ok5_4:

	.data
m6:	.asciiz "\tTesting ble\n"
	.text
	puts	m6
	ble	2, 1, fail
	ble	1, -1, fail
	ble	two, one, fail
	ble	one, _one, fail
	ble	1, 2, ok6_1
	j	fail
ok6_1:	ble	-1, 1, ok6_2
	j	fail
ok6_2:	ble	one, two, ok6_3
	j	fail
ok6_3:	ble	_one, one, ok6_4
	j	fail
ok6_4:	ble	1, 1, ok6_5
	j	fail
ok6_5:	ble	-1, -1, ok6_6
	j	fail
ok6_6:	ble	one, one, ok6_7
	j	fail
ok6_7:	ble	_one, _one, ok6_8
	j	fail
ok6_8:

	.data
m7:	.asciiz "\tTesting bge\n"
	.text
	puts	m7
	bge	1, 2, fail
	bge	-1, 1, fail
	bge	one, two, fail
	bge	_one, one, fail
	bge	2, 1, ok7_1
	j	fail
ok7_1:	bge	1, -1, ok7_2
	j	fail
ok7_2:	bge	two, one, ok7_3
	j	fail
ok7_3:	bge	one, _one, ok7_4
	j	fail
ok7_4:	bge	1, 1, ok7_5
	j	fail
ok7_5:	bge	-1, -1, ok7_6
	j	fail
ok7_6:	bge	one, one, ok7_7
	j	fail
ok7_7:	bge	_one, _one, ok7_8
	j	fail
ok7_8:

	.data
m71:	.asciiz "\tTesting bgez\n"
	.text
	puts	m71
	bgez	-1, fail
	bgez	_one, fail
	bgez	_two, fail
	bgez	1, ok71_1
	j	fail
ok71_1:	bgez	one, ok71_2
	j	fail
ok71_2:	bgez	two, ok71_3
	j	fail
ok71_3: bgez	0, ok71_4
	j	fail
ok71_4:

	.data
m72:	.asciiz "\tTesting bgtz\n"
	.text
	puts	m72
	bgtz	0, fail
	bgtz	-1, fail
	bgtz	_one, fail
	bgtz	_two, fail
	bgtz	1, ok72_1
	j	fail
ok72_1:	bgtz	one, ok72_2
	j	fail
ok72_2:	bgtz	two, ok72_3
	j	fail
ok72_3:

	.data
m73:	.asciiz "\tTesting blez\n"
	.text
	puts	m73
	blez	1, fail
	blez	one, fail
	blez	two, fail
	blez	-1, ok73_1
	j	fail
ok73_1:	blez	_one, ok73_2
	j	fail
ok73_2:	blez	_two, ok73_3
	j	fail
ok73_3: blez	0, ok73_4
	j	fail
ok73_4:

	.data
m74:	.asciiz "\tTesting bltz\n"
	.text
	puts	m74
	bltz	0, fail
	bltz	1, fail
	bltz	one, fail
	bltz	two, fail
	bltz	-1, ok74_1
	j	fail
ok74_1:	bltz	_one, ok74_2
	j	fail
ok74_2:	bltz	_two, ok74_3
	j	fail
ok74_3:

	.data
m75:	.asciiz "\tTesting beqz\n"
	.text
	puts	m75
	beqz	1, fail
	beqz	one, fail
	beqz	_one, fail
	beqz	_two, fail
	beqz	0, ok75_1
	j	fail
ok75_1:

	.data
m76:	.asciiz "\tTesting bnez\n"
	.text
	puts	m76
	bnez	0, fail
	bnez	1, ok76_1
	j	fail
ok76_1:	bnez	one, ok76_2
	j	fail
ok76_2:	bnez	_one, ok76_3
	j	fail
ok76_3:	bnez	_two, ok76_4
	j	fail
ok76_4:

	.data
m8:	.asciiz "Testing shifts\n"
aa:	.word	0x8345deaf
bb:	.word	0x2345feed
xx:	.word
	.text
	puts	m8

	.data
m9:	.asciiz "\tTesting sra\n"
	.text
	puts	m9
	sra	xx, aa, 16
	bne	xx, 0xffff8345, fail
	sra	xx, bb, 16
	bne	xx, 0x00002345, fail
	sra	xx, aa, 2
	bne	xx, 0xe0d177ab, fail
	sra	xx, bb, 2
	bne	xx, 0x08d17fbb, fail

	.data
m10:	.asciiz "\tTesting srl\n"
	.text
	puts	m10
	srl	xx, aa, 16
	bne	xx, 0x00008345, fail
	srl	xx, bb, 16
	bne	xx, 0x00002345, fail
	srl	xx, aa, 2
	bne	xx, 0x20d177ab, fail
	srl	xx, bb, 2
	bne	xx, 0x08d17fbb, fail

	.data
m11:	.asciiz "\tTesting sll\n"
	.text
	puts	m11
	sll	xx, aa, 16
	bne	xx, 0xdeaf0000, fail
	sll	xx, bb, 16
	bne	xx, 0xfeed0000, fail
	sll	xx, aa, 2
	bne	xx, 0x0d177abc, fail
	sll	xx, bb, 2
	bne	xx, 0x8d17fbb4, fail

	.data
m12:	.asciiz "\tTesting rol\n"
	.text
	puts	m12
	rol	xx, aa, 16
	bne	xx, 0xdeaf8345, fail
	rol	xx, bb, 16
	bne	xx, 0xfeed2345, fail
	rol	xx, aa, 2
	bne	xx, 0x0d177abe, fail
	rol	xx, bb, 2
	bne	xx, 0x8d17fbb4, fail

	.data
m13:	.asciiz "\tTesting ror\n"
	.text
	puts	m13
	ror	xx, aa, 16
	bne	xx, 0xdeaf8345, fail
	ror	xx, bb, 16
	bne	xx, 0xfeed2345, fail
	ror	xx, aa, 2
	bne	xx, 0xe0d177ab, fail
	ror	xx, bb, 2
	bne	xx, 0x48d17fbb, fail
	
	.data
m14:	.asciiz "Testing arithmatic\n"
	.text
	puts	m14
	
	.data
m15:	.asciiz "\tTesting add\n"
	.text
	puts	m15
	add	xx, -15, -15
	bne	xx, -30, fail
	add	xx, -15, 17
	bne	xx, 2, fail
	add	xx, -15, -25
	bne	xx, -40, fail
	add	xx, -15, _two
	bne	xx, -17, fail
	add	xx, -15, two
	bne	xx, -13, fail
	add	xx, -15, _one
	bne	xx, -16, fail
	add	xx, 17, -15
	bne	xx, 2, fail
	add	xx, 17, 17
	bne	xx, 34, fail
	add	xx, 17, -25
	bne	xx, -8, fail
	add	xx, 17, _two
	bne	xx, 15, fail
	add	xx, 17, two
	bne	xx, 19, fail
	add	xx, 17, _one
	bne	xx, 16, fail
	add	xx, -25, -15
	bne	xx, -40, fail
	add	xx, -25, 17
	bne	xx, -8, fail
	add	xx, -25, -25
	bne	xx, -50, fail
	add	xx, -25, _two
	bne	xx, -27, fail
	add	xx, -25, two
	bne	xx, -23, fail
	add	xx, -25, _one
	bne	xx, -26, fail
	add	xx, _two, -15
	bne	xx, -17, fail
	add	xx, _two, 17
	bne	xx, 15, fail
	add	xx, _two, -25
	bne	xx, -27, fail
	add	xx, _two, _two
	bne	xx, -4, fail
	add	xx, _two, two
	bne	xx, 0, fail
	add	xx, _two, _one
	bne	xx, -3, fail
	add	xx, two, -15
	bne	xx, -13, fail
	add	xx, two, 17
	bne	xx, 19, fail
	add	xx, two, -25
	bne	xx, -23, fail
	add	xx, two, _two
	bne	xx, 0, fail
	add	xx, two, two
	bne	xx, 4, fail
	add	xx, two, _one
	bne	xx, 1, fail
	add	xx, _one, -15
	bne	xx, -16, fail
	add	xx, _one, 17
	bne	xx, 16, fail
	add	xx, _one, -25
	bne	xx, -26, fail
	add	xx, _one, _two
	bne	xx, -3, fail
	add	xx, _one, two
	bne	xx, 1, fail
	add	xx, _one, _one
	bne	xx, -2, fail
	
	.data
m16:	.asciiz "\tTesting sub\n"
	.text
	puts	m16
	sub	xx, -15, -15
	bne	xx, 0, fail
	sub	xx, -15, 17
	bne	xx, -32, fail
	sub	xx, -15, -25
	bne	xx, 10, fail
	sub	xx, -15, _two
	bne	xx, -13, fail
	sub	xx, -15, two
	bne	xx, -17, fail
	sub	xx, -15, _one
	bne	xx, -14, fail
	sub	xx, 17, -15
	bne	xx, 32, fail
	sub	xx, 17, 17
	bne	xx, 0, fail
	sub	xx, 17, -25
	bne	xx, 42, fail
	sub	xx, 17, _two
	bne	xx, 19, fail
	sub	xx, 17, two
	bne	xx, 15, fail
	sub	xx, 17, _one
	bne	xx, 18, fail
	sub	xx, -25, -15
	bne	xx, -10, fail
	sub	xx, -25, 17
	bne	xx, -42, fail
	sub	xx, -25, -25
	bne	xx, 0, fail
	sub	xx, -25, _two
	bne	xx, -23, fail
	sub	xx, -25, two
	bne	xx, -27, fail
	sub	xx, -25, _one
	bne	xx, -24, fail
	sub	xx, _two, -15
	bne	xx, 13, fail
	sub	xx, _two, 17
	bne	xx, -19, fail
	sub	xx, _two, -25
	bne	xx, 23, fail
	sub	xx, _two, _two
	bne	xx, 0, fail
	sub	xx, _two, two
	bne	xx, -4, fail
	sub	xx, _two, _one
	bne	xx, -1, fail
	sub	xx, two, -15
	bne	xx, 17, fail
	sub	xx, two, 17
	bne	xx, -15, fail
	sub	xx, two, -25
	bne	xx, 27, fail
	sub	xx, two, _two
	bne	xx, 4, fail
	sub	xx, two, two
	bne	xx, 0, fail
	sub	xx, two, _one
	bne	xx, 3, fail
	sub	xx, _one, -15
	bne	xx, 14, fail
	sub	xx, _one, 17
	bne	xx, -18, fail
	sub	xx, _one, -25
	bne	xx, 24, fail
	sub	xx, _one, _two
	bne	xx, 1, fail
	sub	xx, _one, two
	bne	xx, -3, fail
	sub	xx, _one, _one
	bne	xx, 0, fail
	
	.data
m17:	.asciiz "\tTesting mul\n"
	.text
	puts	m17
	mul	xx, -15, -15
	bne	xx, 225, fail
	mul	xx, -15, 17
	bne	xx, -255, fail
	mul	xx, -15, -25
	bne	xx, 375, fail
	mul	xx, -15, _two
	bne	xx, 30, fail
	mul	xx, -15, two
	bne	xx, -30, fail
	mul	xx, -15, _one
	bne	xx, 15, fail
	mul	xx, 17, -15
	bne	xx, -255, fail
	mul	xx, 17, 17
	bne	xx, 289, fail
	mul	xx, 17, -25
	bne	xx, -425, fail
	mul	xx, 17, _two
	bne	xx, -34, fail
	mul	xx, 17, two
	bne	xx, 34, fail
	mul	xx, 17, _one
	bne	xx, -17, fail
	mul	xx, -25, -15
	bne	xx, 375, fail
	mul	xx, -25, 17
	bne	xx, -425, fail
	mul	xx, -25, -25
	bne	xx, 625, fail
	mul	xx, -25, _two
	bne	xx, 50, fail
	mul	xx, -25, two
	bne	xx, -50, fail
	mul	xx, -25, _one
	bne	xx, 25, fail
	mul	xx, _two, -15
	bne	xx, 30, fail
	mul	xx, _two, 17
	bne	xx, -34, fail
	mul	xx, _two, -25
	bne	xx, 50, fail
	mul	xx, _two, _two
	bne	xx, 4, fail
	mul	xx, _two, two
	bne	xx, -4, fail
	mul	xx, _two, _one
	bne	xx, 2, fail
	mul	xx, two, -15
	bne	xx, -30, fail
	mul	xx, two, 17
	bne	xx, 34, fail
	mul	xx, two, -25
	bne	xx, -50, fail
	mul	xx, two, _two
	bne	xx, -4, fail
	mul	xx, two, two
	bne	xx, 4, fail
	mul	xx, two, _one
	bne	xx, -2, fail
	mul	xx, _one, -15
	bne	xx, 15, fail
	mul	xx, _one, 17
	bne	xx, -17, fail
	mul	xx, _one, -25
	bne	xx, 25, fail
	mul	xx, _one, _two
	bne	xx, 2, fail
	mul	xx, _one, two
	bne	xx, -2, fail
	mul	xx, _one, _one
	bne	xx, 1, fail
	
	.data
m18:	.asciiz "\tTesting div\n"
	.text
	puts	m18
	div	xx, -15, -15
	bne	xx, 1, fail
	div	xx, -15, 17
	bne	xx, 0, fail
	div	xx, -15, -25
	bne	xx, 0, fail
	div	xx, -15, _two
	bne	xx, 7, fail
	div	xx, -15, two
	bne	xx, -7, fail
	div	xx, -15, _one
	bne	xx, 15, fail
	div	xx, 17, -15
	bne	xx, -1, fail
	div	xx, 17, 17
	bne	xx, 1, fail
	div	xx, 17, -25
	bne	xx, 0, fail
	div	xx, 17, _two
	bne	xx, -8, fail
	div	xx, 17, two
	bne	xx, 8, fail
	div	xx, 17, _one
	bne	xx, -17, fail
	div	xx, -25, -15
	bne	xx, 1, fail
	div	xx, -25, 17
	bne	xx, -1, fail
	div	xx, -25, -25
	bne	xx, 1, fail
	div	xx, -25, _two
	bne	xx, 12, fail
	div	xx, -25, two
	bne	xx, -12, fail
	div	xx, -25, _one
	bne	xx, 25, fail
	div	xx, _two, -15
	bne	xx, 0, fail
	div	xx, _two, 17
	bne	xx, 0, fail
	div	xx, _two, -25
	bne	xx, 0, fail
	div	xx, _two, _two
	bne	xx, 1, fail
	div	xx, _two, two
	bne	xx, -1, fail
	div	xx, _two, _one
	bne	xx, 2, fail
	div	xx, two, -15
	bne	xx, 0, fail
	div	xx, two, 17
	bne	xx, 0, fail
	div	xx, two, -25
	bne	xx, 0, fail
	div	xx, two, _two
	bne	xx, -1, fail
	div	xx, two, two
	bne	xx, 1, fail
	div	xx, two, _one
	bne	xx, -2, fail
	div	xx, _one, -15
	bne	xx, 0, fail
	div	xx, _one, 17
	bne	xx, 0, fail
	div	xx, _one, -25
	bne	xx, 0, fail
	div	xx, _one, _two
	bne	xx, 0, fail
	div	xx, _one, two
	bne	xx, 0, fail
	div	xx, _one, _one
	bne	xx, 1, fail

	.data
m19:	.asciiz "Testing logical\n"
	.text
	puts	m19

	.data
m20:	.asciiz "\tTesting nor\n"
	.text
	puts	m20
	nor	xx, 0x12345678, 0x12345678
	bne	xx, 0xedcba987, fail
	nor	xx, 0x12345678, 0x87654321
	bne	xx, 0x688aa886, fail
	nor	xx, 0x12345678, bb
	bne	xx, 0xcc8a0102, fail
	nor	xx, 0x87654321, 0x12345678
	bne	xx, 0x688aa886, fail
	nor	xx, 0x87654321, 0x87654321
	bne	xx, 0x789abcde, fail
	nor	xx, 0x87654321, bb
	bne	xx, 0x589a0012, fail
	nor	xx, bb, 0x12345678
	bne	xx, 0xcc8a0102, fail
	nor	xx, bb, 0x87654321
	bne	xx, 0x589a0012, fail
	nor	xx, bb, bb
	bne	xx, 0xdcba0112, fail

	.data
m21:	.asciiz "\tTesting and\n"
	.text
	puts	m21
	and	xx, 0x12345678, 0x12345678
	bne	xx, 0x12345678, fail
	and	xx, 0x12345678, 0x87654321
	bne	xx, 0x2244220, fail
	and	xx, 0x12345678, bb
	bne	xx, 0x2045668, fail
	and	xx, 0x87654321, 0x12345678
	bne	xx, 0x2244220, fail
	and	xx, 0x87654321, 0x87654321
	bne	xx, 0x87654321, fail
	and	xx, 0x87654321, bb
	bne	xx, 0x3454221, fail
	and	xx, bb, 0x12345678
	bne	xx, 0x2045668, fail
	and	xx, bb, 0x87654321
	bne	xx, 0x3454221, fail
	and	xx, bb, bb
	bne	xx, 0x2345feed, fail

	.data
m22:	.asciiz "\tTesting xor\n"
	.text
	puts	m22
	xor	xx, 0x12345678, 0x12345678
	bne	xx, 0x0, fail
	xor	xx, 0x12345678, 0x87654321
	bne	xx, 0x95511559, fail
	xor	xx, 0x12345678, bb
	bne	xx, 0x3171a895, fail
	xor	xx, 0x87654321, 0x12345678
	bne	xx, 0x95511559, fail
	xor	xx, 0x87654321, 0x87654321
	bne	xx, 0x0, fail
	xor	xx, 0x87654321, bb
	bne	xx, 0xa420bdcc, fail
	xor	xx, bb, 0x12345678
	bne	xx, 0x3171a895, fail
	xor	xx, bb, 0x87654321
	bne	xx, 0xa420bdcc, fail
	xor	xx, bb, bb
	bne	xx, 0x0, fail

	.data
m23:	.asciiz "\tTesting or\n"
	.text
	puts	m23
	or	xx, 0x12345678, 0x12345678
	bne	xx, 0x12345678, fail
	or	xx, 0x12345678, 0x87654321
	bne	xx, 0x97755779, fail
	or	xx, 0x12345678, bb
	bne	xx, 0x3375fefd, fail
	or	xx, 0x87654321, 0x12345678
	bne	xx, 0x97755779, fail
	or	xx, 0x87654321, 0x87654321
	bne	xx, 0x87654321, fail
	or	xx, 0x87654321, bb
	bne	xx, 0xa765ffed, fail
	or	xx, bb, 0x12345678
	bne	xx, 0x3375fefd, fail
	or	xx, bb, 0x87654321
	bne	xx, 0xa765ffed, fail
	or	xx, bb, bb
	bne	xx, 0x2345feed, fail

	.data
m24:	.asciiz "\tTesting slt\n"
	.text
	puts	m24
	slt	xx, 0x12345678, 0x12345678
	bne	xx, 0x0, fail
	slt	xx, 0x12345678, 0x87654321
	bne	xx, 0x0, fail
	slt	xx, 0x12345678, bb
	bne	xx, 0x1, fail
	slt	xx, 0x87654321, 0x12345678
	bne	xx, 0x1, fail
	slt	xx, 0x87654321, 0x87654321
	bne	xx, 0x0, fail
	slt	xx, 0x87654321, bb
	bne	xx, 0x1, fail
	slt	xx, bb, 0x12345678
	bne	xx, 0x0, fail
	slt	xx, bb, 0x87654321
	bne	xx, 0x0, fail
	slt	xx, bb, bb
	bne	xx, 0x0, fail

	.data
m25:	.asciiz "\tTesting sltu\n"
	.text
	puts	m25
	sltu	xx, 0x12345678, 0x12345678
	bne	xx, 0x0, fail
	sltu	xx, 0x12345678, 0x87654321
	bne	xx, 0x1, fail
	sltu	xx, 0x12345678, bb
	bne	xx, 0x1, fail
	sltu	xx, 0x87654321, 0x12345678
	bne	xx, 0x0, fail
	sltu	xx, 0x87654321, 0x87654321
	bne	xx, 0x0, fail
	sltu	xx, 0x87654321, bb
	bne	xx, 0x0, fail
	sltu	xx, bb, 0x12345678
	bne	xx, 0x0, fail
	sltu	xx, bb, 0x87654321
	bne	xx, 0x1, fail
	sltu	xx, bb, bb
	bne	xx, 0x0, fail

	.data
m26:	.asciiz "\tTesting move\n"
	.text
	puts	m26
	move	xx, 0x12345678
	bne	xx, 0x12345678, fail
	move	xx, 0x87654321
	bne	xx, 0x87654321, fail
	move	xx, bb
	bne	xx, 0x2345feed, fail

	.data
m30:	.asciiz "Testing la\n"
	.text
	puts	m30
	.data
l30_1:	.word
l30_2:	.word
t30_1:	.word
t30_2:	.word
	.text
	la	t30_1, l30_1
	la	t30_2, l30_2
	sub	xx, t30_2, t30_1
	bne	xx, 4, fail

	.data
m31:	.asciiz "Testing b (xx)\n"
	.text
	puts	m31
	la	xx, ok_31
	b	(xx)
	j	fail
ok_31:

	.data
m0:	.asciiz "Tests passed.\n"
	.text
	puts	m0
	done

