/* SPIM S20 MIPS simulator.
   X interface to SPIM
   Copyright (C) 1990 by James Larus (larus@cs.wisc.edu), James R. Goodman,
   and Alan Yuen-wui Siow.

   SPIM is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 1, or (at your option) any
   later version.

   SPIM is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GNU CC; see the file COPYING.  If not, write to James R.
   Larus, Computer Sciences Department, University of Wisconsin--Madison,
   1210 West Dayton Street, Madison, WI 53706, USA or to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */


/* $Header: /u/scottk/cs354/spim/RCS/xspim.h,v 2.5 1992/12/08 01:57:01 scottk Exp $
 */


#define IO_BUFFSIZE 	10000

#define TEXTHEIGHT \
	(text_font->max_bounds.ascent + text_font->max_bounds.descent)

#define TEXTWIDTH \
	(text_font->max_bounds.width)


/* Global variables for X interface: */

extern XtAppContext app_con;
extern Widget message, console, text2;
extern FILE *outf;
extern int outf_fd;
extern int spim_is_running;

extern Dimension button_width;
extern XFontStruct *text_font;

extern void PopConsole (Widget w, XtPointer client_data, XtPointer call_data);
extern void PopTerminal (Widget w, XtPointer client_data, XtPointer call_data);
extern void execute_program (mem_addr pc, int steps, int display, int cont_bkpt);
extern void initialize_console (void);
extern void read_file (char *name, int assembly_file);
extern void read_input (char *str, int str_size);
extern int read_input_maybe (int which);
extern void redisplay_data (void);
extern void redisplay_text (void);
extern void start_program (mem_addr addr);
extern void control_c_seen ();

#define BELL_VOLUME 50
