/* SPIM S20 MIPS simulator.
   X interface to SPIM
   Copyright (C) 1990 by James Larus (larus@cs.wisc.edu), James R. Goodman,
   and Alan Yuen-wui Siow.

   SPIM is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 1, or (at your option) any
   later version.

   SPIM is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GNU CC; see the file COPYING.  If not, write to James R.
   Larus, Computer Sciences Department, University of Wisconsin--Madison,
   1210 West Dayton Street, Madison, WI 53706, USA or to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */


/* $Header: /u/scottk/cs354/spim/RCS/windows.c,v 2.2 1992/11/20 05:05:40 scottk Exp $
 */


#include <stdio.h>
#include "spim.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Label.h>

#include "xspim.h"
#include "windows.h"


/* Imported functions: */

void CreateButtons ();


/* Internal functions: */

static void create_command_panel ();
static void create_data_window ();
static void create_display_window ();
static void create_reg_window ();
static void create_text_window ();


/* Exported variables: */

Widget register_window, text_window, data_window;



static void
create_reg_window (parent, reg_min_height, reg_max_height)
     Widget parent;
     Dimension reg_min_height, reg_max_height;
{
  Arg args[15];
  Cardinal n = 0;

  XtSetArg (args[n], XtNtype, XawAsciiString); n++;
  XtSetArg (args[n], XtNeditType, XawtextRead); n++;
  XtSetArg (args[n], XtNpreferredPaneSize, reg_min_height); n++;
  XtSetArg (args[n], XtNmin, reg_min_height); n++;
  XtSetArg (args[n], XtNmax, reg_max_height); n++;
  XtSetArg (args[n], XtNresize, "width"); n++;
  XtSetArg (args[n], XtNwrap, "line"); n++;
  XtSetArg (args[n], XtNstring, ""); n++;
  XtSetArg (args[n], XtNlength, 0); n++;
  XtSetArg (args[n], XtNuseStringInPlace, True); n++;
  XtSetArg (args[n], XtNdisplayCaret, False); n++;
  register_window = XtCreateManagedWidget ("register", asciiTextWidgetClass,
					   parent, args, n);
}


static void
create_command_panel (parent, app_width, button_height, command_hspace,
		    command_vspace, command_height)
     Widget parent;
     Dimension app_width, button_height, command_hspace, command_vspace;
     Dimension command_height;
{
  Widget panel;
  Arg args[10];
  Cardinal n = 0;

  XtSetArg (args[n], XtNwidth, app_width); n++;
  XtSetArg (args[n], XtNmin, 2 * button_height + 3 * command_vspace); n++;
  XtSetArg (args[n], XtNmax, command_height); n++;
  XtSetArg (args[n], XtNpreferredPaneSize, 2*button_height + 3 * command_vspace);
  n++;
  XtSetArg (args[n], XtNhSpace, command_hspace); n++;
  XtSetArg (args[n], XtNvSpace, command_vspace); n++;
  XtSetArg (args[n], XtNallowResize, False); n++;
  panel = XtCreateManagedWidget ("panel", boxWidgetClass, parent, args, n);

  CreateButtons (panel);
}


static void
create_text_window (parent, segment_height)
     Widget parent;
     Dimension segment_height;
{
  Arg args[15];
  Cardinal n = 0;

  XtSetArg (args[n], XtNallowResize, False); n++;
  XtSetArg (args[n], XtNshowGrip, False); n++;
  XtSetArg (args[n], XtNresize, False); n++;
  XtSetArg (args[n], XtNmin, TEXTHEIGHT); n++;
  XtSetArg (args[n], XtNlabel, "Text Segments"); n++;
  XtSetArg (args[n], XtNborderWidth, 0); n++;
  XtCreateManagedWidget ("TextSegmentLabel", labelWidgetClass, parent,
			 args, n);

  n = 0;
  XtSetArg (args[n], XtNtype, XawAsciiString); n++;
  XtSetArg (args[n], XtNeditType, XawtextRead); n++;
  XtSetArg (args[n], XtNpreferredPaneSize, segment_height); n++;
  XtSetArg (args[n], XtNstring, ""); n++;
  XtSetArg (args[n], XtNborderWidth, 0); n++;
  XtSetArg (args[n], XtNdisplayCaret, False); n++;
  XtSetArg (args[n], XtNscrollVertical, XawtextScrollWhenNeeded); n++;
  text_window = XtCreateManagedWidget ("file", asciiTextWidgetClass, parent,
				       args, n);
}


static void
create_data_window (parent, segment_height)
     Widget parent;
     Dimension segment_height;
{
  Arg args[15];
  Cardinal n = 0;

  XtSetArg (args[n], XtNallowResize, False); n++;
  XtSetArg (args[n], XtNshowGrip, False); n++;
  XtSetArg (args[n], XtNresize, False); n++;
  XtSetArg (args[n], XtNmin, TEXTHEIGHT); n++;
  XtSetArg (args[n], XtNlabel, "Data Segments"); n++;
  XtSetArg (args[n], XtNborderWidth, 0); n++;
  XtCreateManagedWidget ("DataSegmentLabel", labelWidgetClass, parent,
			 args, n);

  n = 0;
  XtSetArg (args[n], XtNtype, XawAsciiString); n++;
  XtSetArg (args[n], XtNeditType, XawtextRead); n++;
  XtSetArg (args[n], XtNpreferredPaneSize, segment_height); n++;
  XtSetArg (args[n], XtNstring, ""); n++;
  XtSetArg (args[n], XtNborderWidth, 0); n++;
  XtSetArg (args[n], XtNdisplayCaret, False); n++;
  XtSetArg (args[n], XtNscrollVertical, XawtextScrollWhenNeeded); n++;
  data_window = XtCreateManagedWidget ("file", asciiTextWidgetClass, parent,
				       args, n);
}


static void
create_display_window (parent, display_height)
     Widget parent;
     Dimension display_height;
{
  Arg args[15];
  Cardinal n = 0;

  XtSetArg (args[n], XtNeditType, XawtextEdit); n++;
  XtSetArg (args[n], XtNpreferredPaneSize, display_height); n++;
  XtSetArg (args[n], XtNborderWidth, 0); n++;
  XtSetArg (args[n], XtNdisplayCaret, False); n++;
  XtSetArg (args[n], XtNdisplayNonprinting, False); n++;
  XtSetArg (args[n], XtNscrollVertical, XawtextScrollWhenNeeded); n++;
  XtSetArg (args[n], XtNwrap, "line"); n++;
  message = XtCreateManagedWidget ("display", asciiTextWidgetClass, parent,
				   args, n);
  message_out = (int) message;
}


void CreateSubWindows (
     Widget parent,
     Dimension app_width, Dimension reg_min_height, Dimension reg_max_height,
     Dimension command_height, Dimension command_hspace,
     Dimension command_vspace, Dimension button_height,
     Dimension segment_height, Dimension display_height)
{
  Widget pane;
  Arg args[10];
  Cardinal n = 0;

  XtSetArg (args[n], XtNwidth, app_width); n++;
  pane = XtCreateManagedWidget ("pane", panedWidgetClass, parent, args, n);

  create_reg_window (pane, reg_min_height, reg_max_height);
  create_command_panel (pane, app_width, button_height, command_hspace,
			command_vspace, command_height);
  create_text_window (pane, segment_height);
  create_data_window (pane, segment_height);
  create_display_window (pane, display_height);
}
