/* SPIM S20 MIPS simulator.
   Data structures for symbolic addresses.
   Copyright (C) 1990 by James Larus (larus@cs.wisc.edu).

   SPIM is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 1, or (at your option) any
   later version.

   SPIM is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GNU CC; see the file COPYING.  If not, write to James R.
   Larus, Computer Sciences Department, University of Wisconsin--Madison,
   1210 West Dayton Street, Madison, WI 53706, USA or to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */


/* $Header: /u/scottk/cs354/spim/RCS/sym_tbl.h,v 2.2 1992/11/17 18:57:25 scottk Exp $
*/


typedef struct lab_use
{
  instruction *inst;		/* NULL => Data, not code */
  mem_addr addr;
  struct lab_use *next;
} label_use;


/* Symbol table information on a label. */

typedef struct lab
{
  char *name;			/* Name of label */
  int addr;			/* Address of label or 0 if not yet defined */
  unsigned char global_flag;	/* Non-zero => declared global */
  unsigned char gp_flag;	/* Non-zero => referenced off gp */
  unsigned char type;		/* set below */
  struct lab *next;		/* Hash table link */
  struct lab *next_local;	/* Link in list of local labels */
  label_use *uses;		/* List of instructions that reference */
} label;			/* label that has not yet been defined */


#define SYMBOL_IS_DEFINED(SYM) ((SYM)->addr != 0)

#define UNKNOWN_A_TYPE	0
#define WORD_A_TYPE	1
#define FLOAT_A_TYPE	2
#define DOUBLE_A_TYPE	3
#define BYTE_A_TYPE	4

extern	void initialize_symbol_table(void );
extern	label *lookup_label(char *name);
extern	label *record_label(char *name,unsigned long address);
extern	label *set_label_type(label *l,unsigned char type);
extern	int get_label_type(char *name);
extern	label *make_label_global(char *name);
extern	void record_inst_uses_symbol(instruction *inst,unsigned long pc,
    label *sym);
extern	void record_data_uses_symbol(unsigned long location,label *sym);
extern	void resolve_a_label(const label *sym,instruction *inst,unsigned long pc);
extern	void flush_local_labels(void );
extern	unsigned long find_symbol_address(char *symbol);
extern	void print_symbols(void );
extern  void warn_undef(void);
