# SPIM S20 MIPS simulator.
# A test of memory mapped I/O on the Spim simulator.
# Copyright (C) 1992 Scott Kempf, socttk@cs.wisc.edu
#
# SPIM is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 1, or (at your option) any
# later version.
#
# SPIM is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU CC; see the file COPYING.
#
    			# Assign addresses to labels
	.eq	KeyboardData	0xbfff0000
	.eq	KeyboardStatus	0xbfff0004
	.eq	DisplayData	0xbfff0008
	.eq	DisplayStatus	0xbfff000c
	.eq	KeyboardData2	0xbfff0010
	.eq	KeyboardStatus2	0xbfff0014
	.eq	DisplayData2	0xbfff0018
	.eq	DisplayStatus2	0xbfff001c
	.eq	ClockStatus	0xbfff0020

	.ktext
	.space	0x80		# Skip space so kernel starts at 0x80000080
	mfc0	$k0 $12
	and	$k0 0xffff00ff	# Turn off interrupts
	mtc0	$k0 $12
        beq     $k1 $0 expected
        la      $k1 fail
        rfe
        j       $k1

expected:
        mfc0    $k0 $13
        and     $k0 $k0 0xff
        sra     $k0 $k0 2       # $k0 holds ExcCode
        bne     $k0 $0 not_interrupt

        mfc0    $k1 $13
        and     $k1 $k1 0xfffffcff      # Clear software interrupts.
        mtc0    $k1 $13

not_interrupt:
        mfc0    $k1 $14
        add     $k1 $k1 4       # $k1 holds EPC + 4
        rfe
        j       $k1

	.data
fm:	.asciiz "Failed test\n"
	.text
fail:	la $4, fm
	jal PrintString
	li $2, 13
	syscall

PrintString:			# It is used only to print errors.
	lb	$6, ($4)
	beqz	$6, PSCont
PSLoop:	lw	$5, DisplayStatus
	bgez	$5, PSLoop
	sw	$6, DisplayData
	add	$4, $4, 1
	j	PrintString
PSCont:	j	$31

	.text
	.globl __start
__start:
	li $k1 0	# Allow for start-up interrupts
	li $k1 0	# Allow for start-up interrupts
	li $k1 0	# Allow for start-up interrupts
	li $k1 1

	.data
sysmess:.asciiz "Testing syscall\n"
	.text
	la $4 sysmess
	jal PrintString
	li $k1 0
	syscall
sysret: la $3 sysret
	bne $k1 $3 fail
	bne $k0 8 fail

	.data
pm:	.asciiz "All tests passed.\n"
	.text
	la $4 pm
	jal PrintString
	li $2, 13
	syscall
