//============================================================================
// comb_ckt_generator.v
//
// This code is generated by Terasic System Builder
// and modified by M. Hildebrand and B. Baas
//
// 2018/02/05 First version
// 2018/04/24 Routed all board-level switches and LEDs to and from this module
//============================================================================

module comb_ckt_generator (
   // VGA-related signals
   col,
   row,
   red,
   green,
   blue,
   // input push buttons and switches
   KEY,
   SW,
   // output LEDs and 7-segment displays
   LEDR,
   HEX0,
   HEX1,
   HEX2,
   HEX3,
   HEX4,
   HEX5
   );

input  [9:0]  col;
input  [8:0]  row;
output [3:0]  red;    // 4-bit color output
output [3:0]  green;  // 4-bit color output
output [3:0]  blue;   // 4-bit color output

// input push buttons and switches
input  [1:0]  KEY;    // two board-level push buttons KEY1 - KEY0
input  [9:0]  SW;     // ten board-level switches SW9 - SW0

// output LEDs and 7-segment displays
output [9:0]  LEDR;   // ten board-level LEDs LEDR9 - LEDR0
output [7:0]  HEX0;   // board-level 7-segment display
output [7:0]  HEX1;   // board-level 7-segment display
output [7:0]  HEX2;   // board-level 7-segment display
output [7:0]  HEX3;   // board-level 7-segment display
output [7:0]  HEX4;   // board-level 7-segment display
output [7:0]  HEX5;   // board-level 7-segment display


//============================================================================
//  reg/wire declarations
//============================================================================
// More complex implementations will likely declare RGB outputs as regs
// rather than wires
wire [3:0]    red, green, blue;    


//============================================================================
// Board-LED related circuits
//============================================================================

// Temporary simple logic
// The 10 LEDs will light depending on the position of the adjacent 10 switches
assign LEDR = SW;      // ten LEDs assigned to ten switches

// Temporary simple logic
// This block sets the 7-segment HEX displays
// HEX4 - HEX0 are set to all dark
// HEX5 lights segments based on SW9 - SW2
assign HEX0 = 8'b1111_1111;
assign HEX1 = 8'b1111_1111;
assign HEX2 = 8'b1111_1111;
assign HEX3 = 8'b1111_1111;
assign HEX4 = 8'b1111_1111;
assign HEX5 = ~{SW[9], SW[8], SW[7], SW[6], SW[5], SW[4], SW[3], SW[2]};


//==============================================================
// VGA display related circuits
//==============================================================

// Temporary simple logic
// Full intensity is SW[0] is '1'. Blank otherwise
assign red     = SW[0] ? 4'hf : 4'h0; 
assign green   = SW[1] ? 4'hf : 4'h0;
assign blue    = SW[2] ? 4'hf : 4'h0;


endmodule
